/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appsync.model.RuntimeName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AppSyncRuntime
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AppSyncRuntime> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(AppSyncRuntime.getter(AppSyncRuntime::nameAsString)).setter(AppSyncRuntime.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> RUNTIME_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("runtimeVersion").getter(AppSyncRuntime.getter(AppSyncRuntime::runtimeVersion)).setter(AppSyncRuntime.setter(Builder::runtimeVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtimeVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, RUNTIME_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("runtimeVersion", RUNTIME_VERSION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String runtimeVersion;

    private AppSyncRuntime(BuilderImpl builder) {
        this.name = builder.name;
        this.runtimeVersion = builder.runtimeVersion;
    }

    public final RuntimeName name() {
        return RuntimeName.fromValue(this.name);
    }

    public final String nameAsString() {
        return this.name;
    }

    public final String runtimeVersion() {
        return this.runtimeVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppSyncRuntime)) {
            return false;
        }
        AppSyncRuntime other = (AppSyncRuntime)obj;
        return Objects.equals(this.nameAsString(), other.nameAsString()) && Objects.equals(this.runtimeVersion(), other.runtimeVersion());
    }

    public final String toString() {
        return ToString.builder((String)"AppSyncRuntime").add("Name", (Object)this.nameAsString()).add("RuntimeVersion", (Object)this.runtimeVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.nameAsString()));
            }
            case "runtimeVersion": {
                return Optional.ofNullable(clazz.cast(this.runtimeVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AppSyncRuntime, T> g) {
        return obj -> g.apply((AppSyncRuntime)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String runtimeVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(AppSyncRuntime model) {
            this.name(model.name);
            this.runtimeVersion(model.runtimeVersion);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(RuntimeName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final String getRuntimeVersion() {
            return this.runtimeVersion;
        }

        public final void setRuntimeVersion(String runtimeVersion) {
            this.runtimeVersion = runtimeVersion;
        }

        @Override
        public final Builder runtimeVersion(String runtimeVersion) {
            this.runtimeVersion = runtimeVersion;
            return this;
        }

        public AppSyncRuntime build() {
            return new AppSyncRuntime(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AppSyncRuntime> {
        public Builder name(String var1);

        public Builder name(RuntimeName var1);

        public Builder runtimeVersion(String var1);
    }
}

