/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DataSourceType {
    AWS_LAMBDA("AWS_LAMBDA"),
    AMAZON_DYNAMODB("AMAZON_DYNAMODB"),
    AMAZON_ELASTICSEARCH("AMAZON_ELASTICSEARCH"),
    NONE("NONE"),
    HTTP("HTTP"),
    RELATIONAL_DATABASE("RELATIONAL_DATABASE"),
    AMAZON_OPENSEARCH_SERVICE("AMAZON_OPENSEARCH_SERVICE"),
    AMAZON_EVENTBRIDGE("AMAZON_EVENTBRIDGE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DataSourceType> VALUE_MAP;
    private final String value;

    private DataSourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataSourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataSourceType> knownValues() {
        EnumSet<DataSourceType> knownValues = EnumSet.allOf(DataSourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DataSourceType.class, DataSourceType::toString);
    }
}

