/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appsync.model.ApiKey;
import software.amazon.awssdk.services.appsync.model.ApiKeysCopier;
import software.amazon.awssdk.services.appsync.model.AppSyncResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListApiKeysResponse
extends AppSyncResponse
implements ToCopyableBuilder<Builder, ListApiKeysResponse> {
    private static final SdkField<List<ApiKey>> API_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("apiKeys").getter(ListApiKeysResponse.getter(ListApiKeysResponse::apiKeys)).setter(ListApiKeysResponse.setter(Builder::apiKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ApiKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListApiKeysResponse.getter(ListApiKeysResponse::nextToken)).setter(ListApiKeysResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_KEYS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ApiKey> apiKeys;
    private final String nextToken;

    private ListApiKeysResponse(BuilderImpl builder) {
        super(builder);
        this.apiKeys = builder.apiKeys;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasApiKeys() {
        return this.apiKeys != null && !(this.apiKeys instanceof SdkAutoConstructList);
    }

    public final List<ApiKey> apiKeys() {
        return this.apiKeys;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApiKeys() ? this.apiKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApiKeysResponse)) {
            return false;
        }
        ListApiKeysResponse other = (ListApiKeysResponse)((Object)obj);
        return this.hasApiKeys() == other.hasApiKeys() && Objects.equals(this.apiKeys(), other.apiKeys()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListApiKeysResponse").add("ApiKeys", this.hasApiKeys() ? this.apiKeys() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "apiKeys": {
                return Optional.ofNullable(clazz.cast(this.apiKeys()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListApiKeysResponse, T> g) {
        return obj -> g.apply((ListApiKeysResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppSyncResponse.BuilderImpl
    implements Builder {
        private List<ApiKey> apiKeys = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApiKeysResponse model) {
            super(model);
            this.apiKeys(model.apiKeys);
            this.nextToken(model.nextToken);
        }

        public final List<ApiKey.Builder> getApiKeys() {
            List<ApiKey.Builder> result = ApiKeysCopier.copyToBuilder(this.apiKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApiKeys(Collection<ApiKey.BuilderImpl> apiKeys) {
            this.apiKeys = ApiKeysCopier.copyFromBuilder(apiKeys);
        }

        @Override
        public final Builder apiKeys(Collection<ApiKey> apiKeys) {
            this.apiKeys = ApiKeysCopier.copy(apiKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder apiKeys(ApiKey ... apiKeys) {
            this.apiKeys(Arrays.asList(apiKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder apiKeys(Consumer<ApiKey.Builder> ... apiKeys) {
            this.apiKeys(Stream.of(apiKeys).map(c -> (ApiKey)((ApiKey.Builder)ApiKey.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListApiKeysResponse build() {
            return new ListApiKeysResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppSyncResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListApiKeysResponse> {
        public Builder apiKeys(Collection<ApiKey> var1);

        public Builder apiKeys(ApiKey ... var1);

        public Builder apiKeys(Consumer<ApiKey.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

