/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appsync.model.AppSyncResponse;
import software.amazon.awssdk.services.appsync.model.Type;
import software.amazon.awssdk.services.appsync.model.TypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTypesResponse
extends AppSyncResponse
implements ToCopyableBuilder<Builder, ListTypesResponse> {
    private static final SdkField<List<Type>> TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("types").getter(ListTypesResponse.getter(ListTypesResponse::types)).setter(ListTypesResponse.setter(Builder::types)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("types").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Type::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTypesResponse.getter(ListTypesResponse::nextToken)).setter(ListTypesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPES_FIELD, NEXT_TOKEN_FIELD));
    private final List<Type> types;
    private final String nextToken;

    private ListTypesResponse(BuilderImpl builder) {
        super(builder);
        this.types = builder.types;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTypes() {
        return this.types != null && !(this.types instanceof SdkAutoConstructList);
    }

    public final List<Type> types() {
        return this.types;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTypes() ? this.types() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTypesResponse)) {
            return false;
        }
        ListTypesResponse other = (ListTypesResponse)((Object)obj);
        return this.hasTypes() == other.hasTypes() && Objects.equals(this.types(), other.types()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTypesResponse").add("Types", this.hasTypes() ? this.types() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "types": {
                return Optional.ofNullable(clazz.cast(this.types()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTypesResponse, T> g) {
        return obj -> g.apply((ListTypesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppSyncResponse.BuilderImpl
    implements Builder {
        private List<Type> types = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTypesResponse model) {
            super(model);
            this.types(model.types);
            this.nextToken(model.nextToken);
        }

        public final List<Type.Builder> getTypes() {
            List<Type.Builder> result = TypeListCopier.copyToBuilder(this.types);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTypes(Collection<Type.BuilderImpl> types) {
            this.types = TypeListCopier.copyFromBuilder(types);
        }

        @Override
        @Transient
        public final Builder types(Collection<Type> types) {
            this.types = TypeListCopier.copy(types);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder types(Type ... types) {
            this.types(Arrays.asList(types));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder types(Consumer<Type.Builder> ... types) {
            this.types(Stream.of(types).map(c -> (Type)((Type.Builder)Type.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTypesResponse build() {
            return new ListTypesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppSyncResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTypesResponse> {
        public Builder types(Collection<Type> var1);

        public Builder types(Type ... var1);

        public Builder types(Consumer<Type.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

