/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFunctionResponse extends AppSyncResponse implements
        ToCopyableBuilder<GetFunctionResponse.Builder, GetFunctionResponse> {
    private static final SdkField<FunctionConfiguration> FUNCTION_CONFIGURATION_FIELD = SdkField
            .<FunctionConfiguration> builder(MarshallingType.SDK_POJO).getter(getter(GetFunctionResponse::functionConfiguration))
            .setter(setter(Builder::functionConfiguration)).constructor(FunctionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_CONFIGURATION_FIELD));

    private final FunctionConfiguration functionConfiguration;

    private GetFunctionResponse(BuilderImpl builder) {
        super(builder);
        this.functionConfiguration = builder.functionConfiguration;
    }

    /**
     * <p>
     * The <code>Function</code> object.
     * </p>
     * 
     * @return The <code>Function</code> object.
     */
    public FunctionConfiguration functionConfiguration() {
        return functionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(functionConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFunctionResponse)) {
            return false;
        }
        GetFunctionResponse other = (GetFunctionResponse) obj;
        return Objects.equals(functionConfiguration(), other.functionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetFunctionResponse").add("FunctionConfiguration", functionConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "functionConfiguration":
            return Optional.ofNullable(clazz.cast(functionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFunctionResponse, T> g) {
        return obj -> g.apply((GetFunctionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppSyncResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetFunctionResponse> {
        /**
         * <p>
         * The <code>Function</code> object.
         * </p>
         * 
         * @param functionConfiguration
         *        The <code>Function</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionConfiguration(FunctionConfiguration functionConfiguration);

        /**
         * <p>
         * The <code>Function</code> object.
         * </p>
         * This is a convenience that creates an instance of the {@link FunctionConfiguration.Builder} avoiding the need
         * to create one manually via {@link FunctionConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link FunctionConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #functionConfiguration(FunctionConfiguration)}.
         * 
         * @param functionConfiguration
         *        a consumer that will call methods on {@link FunctionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #functionConfiguration(FunctionConfiguration)
         */
        default Builder functionConfiguration(Consumer<FunctionConfiguration.Builder> functionConfiguration) {
            return functionConfiguration(FunctionConfiguration.builder().applyMutation(functionConfiguration).build());
        }
    }

    static final class BuilderImpl extends AppSyncResponse.BuilderImpl implements Builder {
        private FunctionConfiguration functionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFunctionResponse model) {
            super(model);
            functionConfiguration(model.functionConfiguration);
        }

        public final FunctionConfiguration.Builder getFunctionConfiguration() {
            return functionConfiguration != null ? functionConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder functionConfiguration(FunctionConfiguration functionConfiguration) {
            this.functionConfiguration = functionConfiguration;
            return this;
        }

        public final void setFunctionConfiguration(FunctionConfiguration.BuilderImpl functionConfiguration) {
            this.functionConfiguration = functionConfiguration != null ? functionConfiguration.build() : null;
        }

        @Override
        public GetFunctionResponse build() {
            return new GetFunctionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
