/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListResolversByFunctionResponse extends AppSyncResponse implements
        ToCopyableBuilder<ListResolversByFunctionResponse.Builder, ListResolversByFunctionResponse> {
    private static final SdkField<List<Resolver>> RESOLVERS_FIELD = SdkField
            .<List<Resolver>> builder(MarshallingType.LIST)
            .getter(getter(ListResolversByFunctionResponse::resolvers))
            .setter(setter(Builder::resolvers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolvers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Resolver> builder(MarshallingType.SDK_POJO)
                                            .constructor(Resolver::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListResolversByFunctionResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOLVERS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Resolver> resolvers;

    private final String nextToken;

    private ListResolversByFunctionResponse(BuilderImpl builder) {
        super(builder);
        this.resolvers = builder.resolvers;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Resolvers property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasResolvers() {
        return resolvers != null && !(resolvers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of resolvers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResolvers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of resolvers.
     */
    public List<Resolver> resolvers() {
        return resolvers;
    }

    /**
     * <p>
     * An identifier that can be used to return the next set of items in the list.
     * </p>
     * 
     * @return An identifier that can be used to return the next set of items in the list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resolvers());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResolversByFunctionResponse)) {
            return false;
        }
        ListResolversByFunctionResponse other = (ListResolversByFunctionResponse) obj;
        return Objects.equals(resolvers(), other.resolvers()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListResolversByFunctionResponse").add("Resolvers", resolvers()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resolvers":
            return Optional.ofNullable(clazz.cast(resolvers()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResolversByFunctionResponse, T> g) {
        return obj -> g.apply((ListResolversByFunctionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppSyncResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListResolversByFunctionResponse> {
        /**
         * <p>
         * The list of resolvers.
         * </p>
         * 
         * @param resolvers
         *        The list of resolvers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolvers(Collection<Resolver> resolvers);

        /**
         * <p>
         * The list of resolvers.
         * </p>
         * 
         * @param resolvers
         *        The list of resolvers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolvers(Resolver... resolvers);

        /**
         * <p>
         * The list of resolvers.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Resolver>.Builder} avoiding the need to
         * create one manually via {@link List<Resolver>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Resolver>.Builder#build()} is called immediately and its
         * result is passed to {@link #resolvers(List<Resolver>)}.
         * 
         * @param resolvers
         *        a consumer that will call methods on {@link List<Resolver>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resolvers(List<Resolver>)
         */
        Builder resolvers(Consumer<Resolver.Builder>... resolvers);

        /**
         * <p>
         * An identifier that can be used to return the next set of items in the list.
         * </p>
         * 
         * @param nextToken
         *        An identifier that can be used to return the next set of items in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AppSyncResponse.BuilderImpl implements Builder {
        private List<Resolver> resolvers = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResolversByFunctionResponse model) {
            super(model);
            resolvers(model.resolvers);
            nextToken(model.nextToken);
        }

        public final Collection<Resolver.Builder> getResolvers() {
            return resolvers != null ? resolvers.stream().map(Resolver::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resolvers(Collection<Resolver> resolvers) {
            this.resolvers = ResolversCopier.copy(resolvers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resolvers(Resolver... resolvers) {
            resolvers(Arrays.asList(resolvers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resolvers(Consumer<Resolver.Builder>... resolvers) {
            resolvers(Stream.of(resolvers).map(c -> Resolver.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResolvers(Collection<Resolver.BuilderImpl> resolvers) {
            this.resolvers = ResolversCopier.copyFromBuilder(resolvers);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListResolversByFunctionResponse build() {
            return new ListResolversByFunctionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
