/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Delta Sync configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeltaSyncConfig implements SdkPojo, Serializable, ToCopyableBuilder<DeltaSyncConfig.Builder, DeltaSyncConfig> {
    private static final SdkField<Long> BASE_TABLE_TTL_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(DeltaSyncConfig::baseTableTTL)).setter(setter(Builder::baseTableTTL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseTableTTL").build()).build();

    private static final SdkField<String> DELTA_SYNC_TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeltaSyncConfig::deltaSyncTableName)).setter(setter(Builder::deltaSyncTableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deltaSyncTableName").build())
            .build();

    private static final SdkField<Long> DELTA_SYNC_TABLE_TTL_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(DeltaSyncConfig::deltaSyncTableTTL)).setter(setter(Builder::deltaSyncTableTTL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deltaSyncTableTTL").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_TABLE_TTL_FIELD,
            DELTA_SYNC_TABLE_NAME_FIELD, DELTA_SYNC_TABLE_TTL_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long baseTableTTL;

    private final String deltaSyncTableName;

    private final Long deltaSyncTableTTL;

    private DeltaSyncConfig(BuilderImpl builder) {
        this.baseTableTTL = builder.baseTableTTL;
        this.deltaSyncTableName = builder.deltaSyncTableName;
        this.deltaSyncTableTTL = builder.deltaSyncTableTTL;
    }

    /**
     * <p>
     * The number of minutes an Item is stored in the datasource.
     * </p>
     * 
     * @return The number of minutes an Item is stored in the datasource.
     */
    public Long baseTableTTL() {
        return baseTableTTL;
    }

    /**
     * <p>
     * The Delta Sync table name.
     * </p>
     * 
     * @return The Delta Sync table name.
     */
    public String deltaSyncTableName() {
        return deltaSyncTableName;
    }

    /**
     * <p>
     * The number of minutes a Delta Sync log entry is stored in the Delta Sync table.
     * </p>
     * 
     * @return The number of minutes a Delta Sync log entry is stored in the Delta Sync table.
     */
    public Long deltaSyncTableTTL() {
        return deltaSyncTableTTL;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(baseTableTTL());
        hashCode = 31 * hashCode + Objects.hashCode(deltaSyncTableName());
        hashCode = 31 * hashCode + Objects.hashCode(deltaSyncTableTTL());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeltaSyncConfig)) {
            return false;
        }
        DeltaSyncConfig other = (DeltaSyncConfig) obj;
        return Objects.equals(baseTableTTL(), other.baseTableTTL())
                && Objects.equals(deltaSyncTableName(), other.deltaSyncTableName())
                && Objects.equals(deltaSyncTableTTL(), other.deltaSyncTableTTL());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeltaSyncConfig").add("BaseTableTTL", baseTableTTL())
                .add("DeltaSyncTableName", deltaSyncTableName()).add("DeltaSyncTableTTL", deltaSyncTableTTL()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "baseTableTTL":
            return Optional.ofNullable(clazz.cast(baseTableTTL()));
        case "deltaSyncTableName":
            return Optional.ofNullable(clazz.cast(deltaSyncTableName()));
        case "deltaSyncTableTTL":
            return Optional.ofNullable(clazz.cast(deltaSyncTableTTL()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeltaSyncConfig, T> g) {
        return obj -> g.apply((DeltaSyncConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeltaSyncConfig> {
        /**
         * <p>
         * The number of minutes an Item is stored in the datasource.
         * </p>
         * 
         * @param baseTableTTL
         *        The number of minutes an Item is stored in the datasource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseTableTTL(Long baseTableTTL);

        /**
         * <p>
         * The Delta Sync table name.
         * </p>
         * 
         * @param deltaSyncTableName
         *        The Delta Sync table name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deltaSyncTableName(String deltaSyncTableName);

        /**
         * <p>
         * The number of minutes a Delta Sync log entry is stored in the Delta Sync table.
         * </p>
         * 
         * @param deltaSyncTableTTL
         *        The number of minutes a Delta Sync log entry is stored in the Delta Sync table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deltaSyncTableTTL(Long deltaSyncTableTTL);
    }

    static final class BuilderImpl implements Builder {
        private Long baseTableTTL;

        private String deltaSyncTableName;

        private Long deltaSyncTableTTL;

        private BuilderImpl() {
        }

        private BuilderImpl(DeltaSyncConfig model) {
            baseTableTTL(model.baseTableTTL);
            deltaSyncTableName(model.deltaSyncTableName);
            deltaSyncTableTTL(model.deltaSyncTableTTL);
        }

        public final Long getBaseTableTTL() {
            return baseTableTTL;
        }

        @Override
        public final Builder baseTableTTL(Long baseTableTTL) {
            this.baseTableTTL = baseTableTTL;
            return this;
        }

        public final void setBaseTableTTL(Long baseTableTTL) {
            this.baseTableTTL = baseTableTTL;
        }

        public final String getDeltaSyncTableName() {
            return deltaSyncTableName;
        }

        @Override
        public final Builder deltaSyncTableName(String deltaSyncTableName) {
            this.deltaSyncTableName = deltaSyncTableName;
            return this;
        }

        public final void setDeltaSyncTableName(String deltaSyncTableName) {
            this.deltaSyncTableName = deltaSyncTableName;
        }

        public final Long getDeltaSyncTableTTL() {
            return deltaSyncTableTTL;
        }

        @Override
        public final Builder deltaSyncTableTTL(Long deltaSyncTableTTL) {
            this.deltaSyncTableTTL = deltaSyncTableTTL;
            return this;
        }

        public final void setDeltaSyncTableTTL(Long deltaSyncTableTTL) {
            this.deltaSyncTableTTL = deltaSyncTableTTL;
        }

        @Override
        public DeltaSyncConfig build() {
            return new DeltaSyncConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
