/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>CreateApiCache</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateApiCacheRequest extends AppSyncRequest implements
        ToCopyableBuilder<CreateApiCacheRequest.Builder, CreateApiCacheRequest> {
    private static final SdkField<String> API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateApiCacheRequest::apiId)).setter(setter(Builder::apiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiId").build()).build();

    private static final SdkField<Long> TTL_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(CreateApiCacheRequest::ttl)).setter(setter(Builder::ttl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ttl").build()).build();

    private static final SdkField<Boolean> TRANSIT_ENCRYPTION_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateApiCacheRequest::transitEncryptionEnabled)).setter(setter(Builder::transitEncryptionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transitEncryptionEnabled").build())
            .build();

    private static final SdkField<Boolean> AT_REST_ENCRYPTION_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateApiCacheRequest::atRestEncryptionEnabled)).setter(setter(Builder::atRestEncryptionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("atRestEncryptionEnabled").build())
            .build();

    private static final SdkField<String> API_CACHING_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateApiCacheRequest::apiCachingBehaviorAsString)).setter(setter(Builder::apiCachingBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiCachingBehavior").build())
            .build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateApiCacheRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD, TTL_FIELD,
            TRANSIT_ENCRYPTION_ENABLED_FIELD, AT_REST_ENCRYPTION_ENABLED_FIELD, API_CACHING_BEHAVIOR_FIELD, TYPE_FIELD));

    private final String apiId;

    private final Long ttl;

    private final Boolean transitEncryptionEnabled;

    private final Boolean atRestEncryptionEnabled;

    private final String apiCachingBehavior;

    private final String type;

    private CreateApiCacheRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.ttl = builder.ttl;
        this.transitEncryptionEnabled = builder.transitEncryptionEnabled;
        this.atRestEncryptionEnabled = builder.atRestEncryptionEnabled;
        this.apiCachingBehavior = builder.apiCachingBehavior;
        this.type = builder.type;
    }

    /**
     * <p>
     * The GraphQL API Id.
     * </p>
     * 
     * @return The GraphQL API Id.
     */
    public String apiId() {
        return apiId;
    }

    /**
     * <p>
     * TTL in seconds for cache entries.
     * </p>
     * <p>
     * Valid values are between 1 and 3600 seconds.
     * </p>
     * 
     * @return TTL in seconds for cache entries.</p>
     *         <p>
     *         Valid values are between 1 and 3600 seconds.
     */
    public Long ttl() {
        return ttl;
    }

    /**
     * <p>
     * Transit encryption flag when connecting to cache. This setting cannot be updated after creation.
     * </p>
     * 
     * @return Transit encryption flag when connecting to cache. This setting cannot be updated after creation.
     */
    public Boolean transitEncryptionEnabled() {
        return transitEncryptionEnabled;
    }

    /**
     * <p>
     * At rest encryption flag for cache. This setting cannot be updated after creation.
     * </p>
     * 
     * @return At rest encryption flag for cache. This setting cannot be updated after creation.
     */
    public Boolean atRestEncryptionEnabled() {
        return atRestEncryptionEnabled;
    }

    /**
     * <p>
     * Caching behavior.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>FULL_REQUEST_CACHING</b>: All requests are fully cached.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>PER_RESOLVER_CACHING</b>: Individual resovlers that you specify are cached.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #apiCachingBehavior} will return {@link ApiCachingBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #apiCachingBehaviorAsString}.
     * </p>
     * 
     * @return Caching behavior.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>FULL_REQUEST_CACHING</b>: All requests are fully cached.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>PER_RESOLVER_CACHING</b>: Individual resovlers that you specify are cached.
     *         </p>
     *         </li>
     * @see ApiCachingBehavior
     */
    public ApiCachingBehavior apiCachingBehavior() {
        return ApiCachingBehavior.fromValue(apiCachingBehavior);
    }

    /**
     * <p>
     * Caching behavior.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>FULL_REQUEST_CACHING</b>: All requests are fully cached.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>PER_RESOLVER_CACHING</b>: Individual resovlers that you specify are cached.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #apiCachingBehavior} will return {@link ApiCachingBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #apiCachingBehaviorAsString}.
     * </p>
     * 
     * @return Caching behavior.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>FULL_REQUEST_CACHING</b>: All requests are fully cached.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>PER_RESOLVER_CACHING</b>: Individual resovlers that you specify are cached.
     *         </p>
     *         </li>
     * @see ApiCachingBehavior
     */
    public String apiCachingBehaviorAsString() {
        return apiCachingBehavior;
    }

    /**
     * <p>
     * The cache instance type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>T2_SMALL</b>: A t2.small instance type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>T2_MEDIUM</b>: A t2.medium instance type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>R4_LARGE</b>: A r4.large instance type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>R4_XLARGE</b>: A r4.xlarge instance type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>R4_2XLARGE</b>: A r4.2xlarge instance type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>R4_4XLARGE</b>: A r4.4xlarge instance type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>R4_8XLARGE</b>: A r4.8xlarge instance type.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ApiCacheType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The cache instance type.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>T2_SMALL</b>: A t2.small instance type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>T2_MEDIUM</b>: A t2.medium instance type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>R4_LARGE</b>: A r4.large instance type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>R4_XLARGE</b>: A r4.xlarge instance type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>R4_2XLARGE</b>: A r4.2xlarge instance type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>R4_4XLARGE</b>: A r4.4xlarge instance type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>R4_8XLARGE</b>: A r4.8xlarge instance type.
     *         </p>
     *         </li>
     * @see ApiCacheType
     */
    public ApiCacheType type() {
        return ApiCacheType.fromValue(type);
    }

    /**
     * <p>
     * The cache instance type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>T2_SMALL</b>: A t2.small instance type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>T2_MEDIUM</b>: A t2.medium instance type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>R4_LARGE</b>: A r4.large instance type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>R4_XLARGE</b>: A r4.xlarge instance type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>R4_2XLARGE</b>: A r4.2xlarge instance type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>R4_4XLARGE</b>: A r4.4xlarge instance type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>R4_8XLARGE</b>: A r4.8xlarge instance type.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ApiCacheType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The cache instance type.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>T2_SMALL</b>: A t2.small instance type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>T2_MEDIUM</b>: A t2.medium instance type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>R4_LARGE</b>: A r4.large instance type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>R4_XLARGE</b>: A r4.xlarge instance type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>R4_2XLARGE</b>: A r4.2xlarge instance type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>R4_4XLARGE</b>: A r4.4xlarge instance type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>R4_8XLARGE</b>: A r4.8xlarge instance type.
     *         </p>
     *         </li>
     * @see ApiCacheType
     */
    public String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(apiId());
        hashCode = 31 * hashCode + Objects.hashCode(ttl());
        hashCode = 31 * hashCode + Objects.hashCode(transitEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(atRestEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(apiCachingBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApiCacheRequest)) {
            return false;
        }
        CreateApiCacheRequest other = (CreateApiCacheRequest) obj;
        return Objects.equals(apiId(), other.apiId()) && Objects.equals(ttl(), other.ttl())
                && Objects.equals(transitEncryptionEnabled(), other.transitEncryptionEnabled())
                && Objects.equals(atRestEncryptionEnabled(), other.atRestEncryptionEnabled())
                && Objects.equals(apiCachingBehaviorAsString(), other.apiCachingBehaviorAsString())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateApiCacheRequest").add("ApiId", apiId()).add("Ttl", ttl())
                .add("TransitEncryptionEnabled", transitEncryptionEnabled())
                .add("AtRestEncryptionEnabled", atRestEncryptionEnabled())
                .add("ApiCachingBehavior", apiCachingBehaviorAsString()).add("Type", typeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "apiId":
            return Optional.ofNullable(clazz.cast(apiId()));
        case "ttl":
            return Optional.ofNullable(clazz.cast(ttl()));
        case "transitEncryptionEnabled":
            return Optional.ofNullable(clazz.cast(transitEncryptionEnabled()));
        case "atRestEncryptionEnabled":
            return Optional.ofNullable(clazz.cast(atRestEncryptionEnabled()));
        case "apiCachingBehavior":
            return Optional.ofNullable(clazz.cast(apiCachingBehaviorAsString()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateApiCacheRequest, T> g) {
        return obj -> g.apply((CreateApiCacheRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppSyncRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateApiCacheRequest> {
        /**
         * <p>
         * The GraphQL API Id.
         * </p>
         * 
         * @param apiId
         *        The GraphQL API Id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiId(String apiId);

        /**
         * <p>
         * TTL in seconds for cache entries.
         * </p>
         * <p>
         * Valid values are between 1 and 3600 seconds.
         * </p>
         * 
         * @param ttl
         *        TTL in seconds for cache entries.</p>
         *        <p>
         *        Valid values are between 1 and 3600 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ttl(Long ttl);

        /**
         * <p>
         * Transit encryption flag when connecting to cache. This setting cannot be updated after creation.
         * </p>
         * 
         * @param transitEncryptionEnabled
         *        Transit encryption flag when connecting to cache. This setting cannot be updated after creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitEncryptionEnabled(Boolean transitEncryptionEnabled);

        /**
         * <p>
         * At rest encryption flag for cache. This setting cannot be updated after creation.
         * </p>
         * 
         * @param atRestEncryptionEnabled
         *        At rest encryption flag for cache. This setting cannot be updated after creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder atRestEncryptionEnabled(Boolean atRestEncryptionEnabled);

        /**
         * <p>
         * Caching behavior.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>FULL_REQUEST_CACHING</b>: All requests are fully cached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>PER_RESOLVER_CACHING</b>: Individual resovlers that you specify are cached.
         * </p>
         * </li>
         * </ul>
         * 
         * @param apiCachingBehavior
         *        Caching behavior.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>FULL_REQUEST_CACHING</b>: All requests are fully cached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>PER_RESOLVER_CACHING</b>: Individual resovlers that you specify are cached.
         *        </p>
         *        </li>
         * @see ApiCachingBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApiCachingBehavior
         */
        Builder apiCachingBehavior(String apiCachingBehavior);

        /**
         * <p>
         * Caching behavior.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>FULL_REQUEST_CACHING</b>: All requests are fully cached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>PER_RESOLVER_CACHING</b>: Individual resovlers that you specify are cached.
         * </p>
         * </li>
         * </ul>
         * 
         * @param apiCachingBehavior
         *        Caching behavior.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>FULL_REQUEST_CACHING</b>: All requests are fully cached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>PER_RESOLVER_CACHING</b>: Individual resovlers that you specify are cached.
         *        </p>
         *        </li>
         * @see ApiCachingBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApiCachingBehavior
         */
        Builder apiCachingBehavior(ApiCachingBehavior apiCachingBehavior);

        /**
         * <p>
         * The cache instance type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>T2_SMALL</b>: A t2.small instance type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>T2_MEDIUM</b>: A t2.medium instance type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>R4_LARGE</b>: A r4.large instance type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>R4_XLARGE</b>: A r4.xlarge instance type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>R4_2XLARGE</b>: A r4.2xlarge instance type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>R4_4XLARGE</b>: A r4.4xlarge instance type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>R4_8XLARGE</b>: A r4.8xlarge instance type.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The cache instance type.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>T2_SMALL</b>: A t2.small instance type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>T2_MEDIUM</b>: A t2.medium instance type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>R4_LARGE</b>: A r4.large instance type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>R4_XLARGE</b>: A r4.xlarge instance type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>R4_2XLARGE</b>: A r4.2xlarge instance type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>R4_4XLARGE</b>: A r4.4xlarge instance type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>R4_8XLARGE</b>: A r4.8xlarge instance type.
         *        </p>
         *        </li>
         * @see ApiCacheType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApiCacheType
         */
        Builder type(String type);

        /**
         * <p>
         * The cache instance type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>T2_SMALL</b>: A t2.small instance type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>T2_MEDIUM</b>: A t2.medium instance type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>R4_LARGE</b>: A r4.large instance type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>R4_XLARGE</b>: A r4.xlarge instance type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>R4_2XLARGE</b>: A r4.2xlarge instance type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>R4_4XLARGE</b>: A r4.4xlarge instance type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>R4_8XLARGE</b>: A r4.8xlarge instance type.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The cache instance type.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>T2_SMALL</b>: A t2.small instance type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>T2_MEDIUM</b>: A t2.medium instance type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>R4_LARGE</b>: A r4.large instance type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>R4_XLARGE</b>: A r4.xlarge instance type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>R4_2XLARGE</b>: A r4.2xlarge instance type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>R4_4XLARGE</b>: A r4.4xlarge instance type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>R4_8XLARGE</b>: A r4.8xlarge instance type.
         *        </p>
         *        </li>
         * @see ApiCacheType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApiCacheType
         */
        Builder type(ApiCacheType type);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppSyncRequest.BuilderImpl implements Builder {
        private String apiId;

        private Long ttl;

        private Boolean transitEncryptionEnabled;

        private Boolean atRestEncryptionEnabled;

        private String apiCachingBehavior;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApiCacheRequest model) {
            super(model);
            apiId(model.apiId);
            ttl(model.ttl);
            transitEncryptionEnabled(model.transitEncryptionEnabled);
            atRestEncryptionEnabled(model.atRestEncryptionEnabled);
            apiCachingBehavior(model.apiCachingBehavior);
            type(model.type);
        }

        public final String getApiId() {
            return apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        public final Long getTtl() {
            return ttl;
        }

        @Override
        public final Builder ttl(Long ttl) {
            this.ttl = ttl;
            return this;
        }

        public final void setTtl(Long ttl) {
            this.ttl = ttl;
        }

        public final Boolean getTransitEncryptionEnabled() {
            return transitEncryptionEnabled;
        }

        @Override
        public final Builder transitEncryptionEnabled(Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
            return this;
        }

        public final void setTransitEncryptionEnabled(Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
        }

        public final Boolean getAtRestEncryptionEnabled() {
            return atRestEncryptionEnabled;
        }

        @Override
        public final Builder atRestEncryptionEnabled(Boolean atRestEncryptionEnabled) {
            this.atRestEncryptionEnabled = atRestEncryptionEnabled;
            return this;
        }

        public final void setAtRestEncryptionEnabled(Boolean atRestEncryptionEnabled) {
            this.atRestEncryptionEnabled = atRestEncryptionEnabled;
        }

        public final String getApiCachingBehaviorAsString() {
            return apiCachingBehavior;
        }

        @Override
        public final Builder apiCachingBehavior(String apiCachingBehavior) {
            this.apiCachingBehavior = apiCachingBehavior;
            return this;
        }

        @Override
        public final Builder apiCachingBehavior(ApiCachingBehavior apiCachingBehavior) {
            this.apiCachingBehavior(apiCachingBehavior == null ? null : apiCachingBehavior.toString());
            return this;
        }

        public final void setApiCachingBehavior(String apiCachingBehavior) {
            this.apiCachingBehavior = apiCachingBehavior;
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ApiCacheType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateApiCacheRequest build() {
            return new CreateApiCacheRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
