/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.appsync.model.Resolver;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ResolverMarshaller {
    private static final MarshallingInfo<String> TYPENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("typeName").isBinary(false).build();
    private static final MarshallingInfo<String> FIELDNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fieldName").isBinary(false).build();
    private static final MarshallingInfo<String> DATASOURCENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dataSourceName").isBinary(false).build();
    private static final MarshallingInfo<String> RESOLVERARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resolverArn").isBinary(false).build();
    private static final MarshallingInfo<String> REQUESTMAPPINGTEMPLATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("requestMappingTemplate").isBinary(false).build();
    private static final MarshallingInfo<String> RESPONSEMAPPINGTEMPLATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("responseMappingTemplate").isBinary(false).build();
    private static final ResolverMarshaller INSTANCE = new ResolverMarshaller();

    private ResolverMarshaller() {
    }

    public static ResolverMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Resolver resolver, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)resolver, (String)"resolver");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)resolver.typeName(), TYPENAME_BINDING);
            protocolMarshaller.marshall((Object)resolver.fieldName(), FIELDNAME_BINDING);
            protocolMarshaller.marshall((Object)resolver.dataSourceName(), DATASOURCENAME_BINDING);
            protocolMarshaller.marshall((Object)resolver.resolverArn(), RESOLVERARN_BINDING);
            protocolMarshaller.marshall((Object)resolver.requestMappingTemplate(), REQUESTMAPPINGTEMPLATE_BINDING);
            protocolMarshaller.marshall((Object)resolver.responseMappingTemplate(), RESPONSEMAPPINGTEMPLATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

