/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.core.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.appsync.model.AppSyncRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StartSchemaCreationRequest
extends AppSyncRequest
implements ToCopyableBuilder<Builder, StartSchemaCreationRequest> {
    private final String apiId;
    private final ByteBuffer definition;

    private StartSchemaCreationRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.definition = builder.definition;
    }

    public String apiId() {
        return this.apiId;
    }

    public ByteBuffer definition() {
        return this.definition == null ? null : this.definition.asReadOnlyBuffer();
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.apiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSchemaCreationRequest)) {
            return false;
        }
        StartSchemaCreationRequest other = (StartSchemaCreationRequest)((Object)obj);
        return Objects.equals(this.apiId(), other.apiId()) && Objects.equals(this.definition(), other.definition());
    }

    public String toString() {
        return ToString.builder((String)"StartSchemaCreationRequest").add("ApiId", (Object)this.apiId()).add("Definition", (Object)this.definition()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "apiId": {
                return Optional.of(clazz.cast(this.apiId()));
            }
            case "definition": {
                return Optional.of(clazz.cast(this.definition()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AppSyncRequest.BuilderImpl
    implements Builder {
        private String apiId;
        private ByteBuffer definition;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSchemaCreationRequest model) {
            this.apiId(model.apiId);
            this.definition(model.definition);
        }

        public final String getApiId() {
            return this.apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        public final ByteBuffer getDefinition() {
            return this.definition;
        }

        @Override
        public final Builder definition(ByteBuffer definition) {
            this.definition = StandardMemberCopier.copy((ByteBuffer)definition);
            return this;
        }

        public final void setDefinition(ByteBuffer definition) {
            this.definition = StandardMemberCopier.copy((ByteBuffer)definition);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public StartSchemaCreationRequest build() {
            return new StartSchemaCreationRequest(this);
        }
    }

    public static interface Builder
    extends AppSyncRequest.Builder,
    CopyableBuilder<Builder, StartSchemaCreationRequest> {
        public Builder apiId(String var1);

        public Builder definition(ByteBuffer var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

