/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.appsync.model.ElasticsearchDataSourceConfig;

public class ElasticsearchDataSourceConfigUnmarshaller
implements Unmarshaller<ElasticsearchDataSourceConfig, JsonUnmarshallerContext> {
    private static final ElasticsearchDataSourceConfigUnmarshaller INSTANCE = new ElasticsearchDataSourceConfigUnmarshaller();

    public ElasticsearchDataSourceConfig unmarshall(JsonUnmarshallerContext context) throws Exception {
        ElasticsearchDataSourceConfig.Builder elasticsearchDataSourceConfigBuilder = ElasticsearchDataSourceConfig.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("endpoint", targetDepth)) {
                    context.nextToken();
                    elasticsearchDataSourceConfigBuilder.endpoint((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("awsRegion", targetDepth)) {
                    context.nextToken();
                    elasticsearchDataSourceConfigBuilder.awsRegion((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ElasticsearchDataSourceConfig)elasticsearchDataSourceConfigBuilder.build();
    }

    public static ElasticsearchDataSourceConfigUnmarshaller getInstance() {
        return INSTANCE;
    }
}

