/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.appsync.model.Resolver;
import software.amazon.awssdk.services.appsync.model.ResolversCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListResolversResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListResolversResponse> {
    private final List<Resolver> resolvers;
    private final String nextToken;

    private ListResolversResponse(BuilderImpl builder) {
        this.resolvers = builder.resolvers;
        this.nextToken = builder.nextToken;
    }

    public List<Resolver> resolvers() {
        return this.resolvers;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resolvers());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResolversResponse)) {
            return false;
        }
        ListResolversResponse other = (ListResolversResponse)((Object)obj);
        return Objects.equals(this.resolvers(), other.resolvers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.resolvers() != null) {
            sb.append("Resolvers: ").append(this.resolvers()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resolvers": {
                return Optional.of(clazz.cast(this.resolvers()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Resolver> resolvers;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResolversResponse model) {
            this.resolvers(model.resolvers);
            this.nextToken(model.nextToken);
        }

        public final Collection<Resolver.Builder> getResolvers() {
            return this.resolvers != null ? (Collection)this.resolvers.stream().map(Resolver::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resolvers(Collection<Resolver> resolvers) {
            this.resolvers = ResolversCopier.copy(resolvers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resolvers(Resolver ... resolvers) {
            this.resolvers(Arrays.asList(resolvers));
            return this;
        }

        public final void setResolvers(Collection<Resolver.BuilderImpl> resolvers) {
            this.resolvers = ResolversCopier.copyFromBuilder(resolvers);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListResolversResponse build() {
            return new ListResolversResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListResolversResponse> {
        public Builder resolvers(Collection<Resolver> var1);

        public Builder resolvers(Resolver ... var1);

        public Builder nextToken(String var1);
    }
}

