/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Resolver
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Resolver> {
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Resolver.getter(Resolver::typeName)).setter(Resolver.setter(Builder::typeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeName").build()}).build();
    private static final SdkField<String> FIELD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Resolver.getter(Resolver::fieldName)).setter(Resolver.setter(Builder::fieldName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldName").build()}).build();
    private static final SdkField<String> DATA_SOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Resolver.getter(Resolver::dataSourceName)).setter(Resolver.setter(Builder::dataSourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceName").build()}).build();
    private static final SdkField<String> RESOLVER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Resolver.getter(Resolver::resolverArn)).setter(Resolver.setter(Builder::resolverArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolverArn").build()}).build();
    private static final SdkField<String> REQUEST_MAPPING_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Resolver.getter(Resolver::requestMappingTemplate)).setter(Resolver.setter(Builder::requestMappingTemplate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestMappingTemplate").build()}).build();
    private static final SdkField<String> RESPONSE_MAPPING_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Resolver.getter(Resolver::responseMappingTemplate)).setter(Resolver.setter(Builder::responseMappingTemplate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseMappingTemplate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_NAME_FIELD, FIELD_NAME_FIELD, DATA_SOURCE_NAME_FIELD, RESOLVER_ARN_FIELD, REQUEST_MAPPING_TEMPLATE_FIELD, RESPONSE_MAPPING_TEMPLATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String typeName;
    private final String fieldName;
    private final String dataSourceName;
    private final String resolverArn;
    private final String requestMappingTemplate;
    private final String responseMappingTemplate;

    private Resolver(BuilderImpl builder) {
        this.typeName = builder.typeName;
        this.fieldName = builder.fieldName;
        this.dataSourceName = builder.dataSourceName;
        this.resolverArn = builder.resolverArn;
        this.requestMappingTemplate = builder.requestMappingTemplate;
        this.responseMappingTemplate = builder.responseMappingTemplate;
    }

    public String typeName() {
        return this.typeName;
    }

    public String fieldName() {
        return this.fieldName;
    }

    public String dataSourceName() {
        return this.dataSourceName;
    }

    public String resolverArn() {
        return this.resolverArn;
    }

    public String requestMappingTemplate() {
        return this.requestMappingTemplate;
    }

    public String responseMappingTemplate() {
        return this.responseMappingTemplate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolverArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestMappingTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseMappingTemplate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resolver)) {
            return false;
        }
        Resolver other = (Resolver)obj;
        return Objects.equals(this.typeName(), other.typeName()) && Objects.equals(this.fieldName(), other.fieldName()) && Objects.equals(this.dataSourceName(), other.dataSourceName()) && Objects.equals(this.resolverArn(), other.resolverArn()) && Objects.equals(this.requestMappingTemplate(), other.requestMappingTemplate()) && Objects.equals(this.responseMappingTemplate(), other.responseMappingTemplate());
    }

    public String toString() {
        return ToString.builder((String)"Resolver").add("TypeName", (Object)this.typeName()).add("FieldName", (Object)this.fieldName()).add("DataSourceName", (Object)this.dataSourceName()).add("ResolverArn", (Object)this.resolverArn()).add("RequestMappingTemplate", (Object)this.requestMappingTemplate()).add("ResponseMappingTemplate", (Object)this.responseMappingTemplate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "typeName": {
                return Optional.ofNullable(clazz.cast(this.typeName()));
            }
            case "fieldName": {
                return Optional.ofNullable(clazz.cast(this.fieldName()));
            }
            case "dataSourceName": {
                return Optional.ofNullable(clazz.cast(this.dataSourceName()));
            }
            case "resolverArn": {
                return Optional.ofNullable(clazz.cast(this.resolverArn()));
            }
            case "requestMappingTemplate": {
                return Optional.ofNullable(clazz.cast(this.requestMappingTemplate()));
            }
            case "responseMappingTemplate": {
                return Optional.ofNullable(clazz.cast(this.responseMappingTemplate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Resolver, T> g) {
        return obj -> g.apply((Resolver)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String typeName;
        private String fieldName;
        private String dataSourceName;
        private String resolverArn;
        private String requestMappingTemplate;
        private String responseMappingTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(Resolver model) {
            this.typeName(model.typeName);
            this.fieldName(model.fieldName);
            this.dataSourceName(model.dataSourceName);
            this.resolverArn(model.resolverArn);
            this.requestMappingTemplate(model.requestMappingTemplate);
            this.responseMappingTemplate(model.responseMappingTemplate);
        }

        public final String getTypeName() {
            return this.typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public final String getFieldName() {
            return this.fieldName;
        }

        @Override
        public final Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public final void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public final String getDataSourceName() {
            return this.dataSourceName;
        }

        @Override
        public final Builder dataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
            return this;
        }

        public final void setDataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
        }

        public final String getResolverArn() {
            return this.resolverArn;
        }

        @Override
        public final Builder resolverArn(String resolverArn) {
            this.resolverArn = resolverArn;
            return this;
        }

        public final void setResolverArn(String resolverArn) {
            this.resolverArn = resolverArn;
        }

        public final String getRequestMappingTemplate() {
            return this.requestMappingTemplate;
        }

        @Override
        public final Builder requestMappingTemplate(String requestMappingTemplate) {
            this.requestMappingTemplate = requestMappingTemplate;
            return this;
        }

        public final void setRequestMappingTemplate(String requestMappingTemplate) {
            this.requestMappingTemplate = requestMappingTemplate;
        }

        public final String getResponseMappingTemplate() {
            return this.responseMappingTemplate;
        }

        @Override
        public final Builder responseMappingTemplate(String responseMappingTemplate) {
            this.responseMappingTemplate = responseMappingTemplate;
            return this;
        }

        public final void setResponseMappingTemplate(String responseMappingTemplate) {
            this.responseMappingTemplate = responseMappingTemplate;
        }

        public Resolver build() {
            return new Resolver(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Resolver> {
        public Builder typeName(String var1);

        public Builder fieldName(String var1);

        public Builder dataSourceName(String var1);

        public Builder resolverArn(String var1);

        public Builder requestMappingTemplate(String var1);

        public Builder responseMappingTemplate(String var1);
    }
}

