/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.appsync.model.OpenIDConnectConfig;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class OpenIDConnectConfigMarshaller {
    private static final MarshallingInfo<String> ISSUER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("issuer").isBinary(false).build();
    private static final MarshallingInfo<String> CLIENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("clientId").isBinary(false).build();
    private static final MarshallingInfo<Long> IATTTL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("iatTTL").isBinary(false).build();
    private static final MarshallingInfo<Long> AUTHTTL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authTTL").isBinary(false).build();
    private static final OpenIDConnectConfigMarshaller INSTANCE = new OpenIDConnectConfigMarshaller();

    private OpenIDConnectConfigMarshaller() {
    }

    public static OpenIDConnectConfigMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(OpenIDConnectConfig openIDConnectConfig, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)openIDConnectConfig, (String)"openIDConnectConfig");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)openIDConnectConfig.issuer(), ISSUER_BINDING);
            protocolMarshaller.marshall((Object)openIDConnectConfig.clientId(), CLIENTID_BINDING);
            protocolMarshaller.marshall((Object)openIDConnectConfig.iatTTL(), IATTTL_BINDING);
            protocolMarshaller.marshall((Object)openIDConnectConfig.authTTL(), AUTHTTL_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

