/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.appsync.model.LogConfig;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class LogConfigMarshaller {
    private static final MarshallingInfo<String> FIELDLOGLEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fieldLogLevel").isBinary(false).build();
    private static final MarshallingInfo<String> CLOUDWATCHLOGSROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cloudWatchLogsRoleArn").isBinary(false).build();
    private static final LogConfigMarshaller INSTANCE = new LogConfigMarshaller();

    private LogConfigMarshaller() {
    }

    public static LogConfigMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(LogConfig logConfig, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)logConfig, (String)"logConfig");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)logConfig.fieldLogLevelAsString(), FIELDLOGLEVEL_BINDING);
            protocolMarshaller.marshall((Object)logConfig.cloudWatchLogsRoleArn(), CLOUDWATCHLOGSROLEARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

