/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.appsync.model.DeleteApiKeyRequest;
import software.amazon.awssdk.services.appsync.transform.DeleteApiKeyRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DeleteApiKeyRequestMarshaller
implements Marshaller<Request<DeleteApiKeyRequest>, DeleteApiKeyRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/v1/apis/{apiId}/apikeys/{id}").httpMethodName(HttpMethodName.DELETE).hasExplicitPayloadMember(false).hasPayloadMembers(false).build();
    private final AwsJsonProtocolFactory protocolFactory;

    public DeleteApiKeyRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DeleteApiKeyRequest> marshall(DeleteApiKeyRequest deleteApiKeyRequest) {
        Validate.paramNotNull((Object)((Object)deleteApiKeyRequest), (String)"deleteApiKeyRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)deleteApiKeyRequest);
            protocolMarshaller.startMarshalling();
            DeleteApiKeyRequestModelMarshaller.getInstance().marshall(deleteApiKeyRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

