/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appsync.model.FieldLogLevel;
import software.amazon.awssdk.services.appsync.transform.LogConfigMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LogConfig
implements StructuredPojo,
ToCopyableBuilder<Builder, LogConfig> {
    private final String fieldLogLevel;
    private final String cloudWatchLogsRoleArn;

    private LogConfig(BuilderImpl builder) {
        this.fieldLogLevel = builder.fieldLogLevel;
        this.cloudWatchLogsRoleArn = builder.cloudWatchLogsRoleArn;
    }

    public FieldLogLevel fieldLogLevel() {
        return FieldLogLevel.fromValue(this.fieldLogLevel);
    }

    public String fieldLogLevelAsString() {
        return this.fieldLogLevel;
    }

    public String cloudWatchLogsRoleArn() {
        return this.cloudWatchLogsRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldLogLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogsRoleArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogConfig)) {
            return false;
        }
        LogConfig other = (LogConfig)obj;
        return Objects.equals(this.fieldLogLevelAsString(), other.fieldLogLevelAsString()) && Objects.equals(this.cloudWatchLogsRoleArn(), other.cloudWatchLogsRoleArn());
    }

    public String toString() {
        return ToString.builder((String)"LogConfig").add("FieldLogLevel", (Object)this.fieldLogLevelAsString()).add("CloudWatchLogsRoleArn", (Object)this.cloudWatchLogsRoleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fieldLogLevel": {
                return Optional.ofNullable(clazz.cast(this.fieldLogLevelAsString()));
            }
            case "cloudWatchLogsRoleArn": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogsRoleArn()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LogConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String fieldLogLevel;
        private String cloudWatchLogsRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(LogConfig model) {
            this.fieldLogLevel(model.fieldLogLevel);
            this.cloudWatchLogsRoleArn(model.cloudWatchLogsRoleArn);
        }

        public final String getFieldLogLevel() {
            return this.fieldLogLevel;
        }

        @Override
        public final Builder fieldLogLevel(String fieldLogLevel) {
            this.fieldLogLevel = fieldLogLevel;
            return this;
        }

        @Override
        public final Builder fieldLogLevel(FieldLogLevel fieldLogLevel) {
            this.fieldLogLevel(fieldLogLevel.toString());
            return this;
        }

        public final void setFieldLogLevel(String fieldLogLevel) {
            this.fieldLogLevel = fieldLogLevel;
        }

        public final String getCloudWatchLogsRoleArn() {
            return this.cloudWatchLogsRoleArn;
        }

        @Override
        public final Builder cloudWatchLogsRoleArn(String cloudWatchLogsRoleArn) {
            this.cloudWatchLogsRoleArn = cloudWatchLogsRoleArn;
            return this;
        }

        public final void setCloudWatchLogsRoleArn(String cloudWatchLogsRoleArn) {
            this.cloudWatchLogsRoleArn = cloudWatchLogsRoleArn;
        }

        public LogConfig build() {
            return new LogConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LogConfig> {
        public Builder fieldLogLevel(String var1);

        public Builder fieldLogLevel(FieldLogLevel var1);

        public Builder cloudWatchLogsRoleArn(String var1);
    }
}

