/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.appsync.model.AppSyncResponse;
import software.amazon.awssdk.services.appsync.model.DataSource;
import software.amazon.awssdk.services.appsync.model.DataSourcesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDataSourcesResponse
extends AppSyncResponse
implements ToCopyableBuilder<Builder, ListDataSourcesResponse> {
    private final List<DataSource> dataSources;
    private final String nextToken;

    private ListDataSourcesResponse(BuilderImpl builder) {
        super(builder);
        this.dataSources = builder.dataSources;
        this.nextToken = builder.nextToken;
    }

    public List<DataSource> dataSources() {
        return this.dataSources;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSources());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataSourcesResponse)) {
            return false;
        }
        ListDataSourcesResponse other = (ListDataSourcesResponse)((Object)obj);
        return Objects.equals(this.dataSources(), other.dataSources()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListDataSourcesResponse").add("DataSources", this.dataSources()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dataSources": {
                return Optional.ofNullable(clazz.cast(this.dataSources()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AppSyncResponse.BuilderImpl
    implements Builder {
        private List<DataSource> dataSources = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataSourcesResponse model) {
            super(model);
            this.dataSources(model.dataSources);
            this.nextToken(model.nextToken);
        }

        public final Collection<DataSource.Builder> getDataSources() {
            return this.dataSources != null ? (Collection)this.dataSources.stream().map(DataSource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dataSources(Collection<DataSource> dataSources) {
            this.dataSources = DataSourcesCopier.copy(dataSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSources(DataSource ... dataSources) {
            this.dataSources(Arrays.asList(dataSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSources(Consumer<DataSource.Builder> ... dataSources) {
            this.dataSources(Stream.of(dataSources).map(c -> (DataSource)((DataSource.Builder)DataSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDataSources(Collection<DataSource.BuilderImpl> dataSources) {
            this.dataSources = DataSourcesCopier.copyFromBuilder(dataSources);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDataSourcesResponse build() {
            return new ListDataSourcesResponse(this);
        }
    }

    public static interface Builder
    extends AppSyncResponse.Builder,
    CopyableBuilder<Builder, ListDataSourcesResponse> {
        public Builder dataSources(Collection<DataSource> var1);

        public Builder dataSources(DataSource ... var1);

        public Builder dataSources(Consumer<DataSource.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

