/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.appsync.model.AuthenticationType;
import software.amazon.awssdk.services.appsync.model.MapOfStringToStringCopier;
import software.amazon.awssdk.services.appsync.model.UserPoolConfig;
import software.amazon.awssdk.services.appsync.transform.GraphqlApiMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GraphqlApi
implements StructuredPojo,
ToCopyableBuilder<Builder, GraphqlApi> {
    private final String name;
    private final String apiId;
    private final String authenticationType;
    private final UserPoolConfig userPoolConfig;
    private final String arn;
    private final Map<String, String> uris;

    private GraphqlApi(BuilderImpl builder) {
        this.name = builder.name;
        this.apiId = builder.apiId;
        this.authenticationType = builder.authenticationType;
        this.userPoolConfig = builder.userPoolConfig;
        this.arn = builder.arn;
        this.uris = builder.uris;
    }

    public String name() {
        return this.name;
    }

    public String apiId() {
        return this.apiId;
    }

    public AuthenticationType authenticationType() {
        return AuthenticationType.fromValue(this.authenticationType);
    }

    public String authenticationTypeAsString() {
        return this.authenticationType;
    }

    public UserPoolConfig userPoolConfig() {
        return this.userPoolConfig;
    }

    public String arn() {
        return this.arn;
    }

    public Map<String, String> uris() {
        return this.uris;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.uris());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GraphqlApi)) {
            return false;
        }
        GraphqlApi other = (GraphqlApi)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.apiId(), other.apiId()) && Objects.equals(this.authenticationTypeAsString(), other.authenticationTypeAsString()) && Objects.equals(this.userPoolConfig(), other.userPoolConfig()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.uris(), other.uris());
    }

    public String toString() {
        return ToString.builder((String)"GraphqlApi").add("Name", (Object)this.name()).add("ApiId", (Object)this.apiId()).add("AuthenticationType", (Object)this.authenticationTypeAsString()).add("UserPoolConfig", (Object)this.userPoolConfig()).add("Arn", (Object)this.arn()).add("Uris", this.uris()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "apiId": {
                return Optional.ofNullable(clazz.cast(this.apiId()));
            }
            case "authenticationType": {
                return Optional.ofNullable(clazz.cast(this.authenticationTypeAsString()));
            }
            case "userPoolConfig": {
                return Optional.ofNullable(clazz.cast(this.userPoolConfig()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "uris": {
                return Optional.ofNullable(clazz.cast(this.uris()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GraphqlApiMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String apiId;
        private String authenticationType;
        private UserPoolConfig userPoolConfig;
        private String arn;
        private Map<String, String> uris = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GraphqlApi model) {
            this.name(model.name);
            this.apiId(model.apiId);
            this.authenticationType(model.authenticationType);
            this.userPoolConfig(model.userPoolConfig);
            this.arn(model.arn);
            this.uris(model.uris);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getApiId() {
            return this.apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        public final String getAuthenticationType() {
            return this.authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType.toString());
            return this;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        public final UserPoolConfig.Builder getUserPoolConfig() {
            return this.userPoolConfig != null ? this.userPoolConfig.toBuilder() : null;
        }

        @Override
        public final Builder userPoolConfig(UserPoolConfig userPoolConfig) {
            this.userPoolConfig = userPoolConfig;
            return this;
        }

        public final void setUserPoolConfig(UserPoolConfig.BuilderImpl userPoolConfig) {
            this.userPoolConfig = userPoolConfig != null ? userPoolConfig.build() : null;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Map<String, String> getUris() {
            return this.uris;
        }

        @Override
        public final Builder uris(Map<String, String> uris) {
            this.uris = MapOfStringToStringCopier.copy(uris);
            return this;
        }

        public final void setUris(Map<String, String> uris) {
            this.uris = MapOfStringToStringCopier.copy(uris);
        }

        public GraphqlApi build() {
            return new GraphqlApi(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GraphqlApi> {
        public Builder name(String var1);

        public Builder apiId(String var1);

        public Builder authenticationType(String var1);

        public Builder authenticationType(AuthenticationType var1);

        public Builder userPoolConfig(UserPoolConfig var1);

        default public Builder userPoolConfig(Consumer<UserPoolConfig.Builder> userPoolConfig) {
            return this.userPoolConfig((UserPoolConfig)((UserPoolConfig.Builder)UserPoolConfig.builder().applyMutation(userPoolConfig)).build());
        }

        public Builder arn(String var1);

        public Builder uris(Map<String, String> var1);
    }
}

