/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.appsync.model.UserPoolConfig;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UserPoolConfigMarshaller {
    private static final MarshallingInfo<String> USERPOOLID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("userPoolId").isBinary(false).build();
    private static final MarshallingInfo<String> AWSREGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("awsRegion").isBinary(false).build();
    private static final MarshallingInfo<String> DEFAULTACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("defaultAction").isBinary(false).build();
    private static final MarshallingInfo<String> APPIDCLIENTREGEX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("appIdClientRegex").isBinary(false).build();
    private static final UserPoolConfigMarshaller INSTANCE = new UserPoolConfigMarshaller();

    private UserPoolConfigMarshaller() {
    }

    public static UserPoolConfigMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UserPoolConfig userPoolConfig, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)userPoolConfig, (String)"userPoolConfig");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)userPoolConfig.userPoolId(), USERPOOLID_BINDING);
            protocolMarshaller.marshall((Object)userPoolConfig.awsRegion(), AWSREGION_BINDING);
            protocolMarshaller.marshall((Object)userPoolConfig.defaultActionAsString(), DEFAULTACTION_BINDING);
            protocolMarshaller.marshall((Object)userPoolConfig.appIdClientRegex(), APPIDCLIENTREGEX_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

