/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.appsync.model.ListTypesRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ListTypesRequestModelMarshaller {
    private static final MarshallingInfo<String> APIID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("apiId").isBinary(false).build();
    private static final MarshallingInfo<String> FORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("format").isBinary(false).build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("nextToken").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXRESULTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("maxResults").isBinary(false).build();
    private static final ListTypesRequestModelMarshaller INSTANCE = new ListTypesRequestModelMarshaller();

    private ListTypesRequestModelMarshaller() {
    }

    public static ListTypesRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ListTypesRequest listTypesRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)listTypesRequest), (String)"listTypesRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)listTypesRequest.apiId(), APIID_BINDING);
            protocolMarshaller.marshall((Object)listTypesRequest.formatAsString(), FORMAT_BINDING);
            protocolMarshaller.marshall((Object)listTypesRequest.nextToken(), NEXTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)listTypesRequest.maxResults(), MAXRESULTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

