/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationSettings> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ApplicationSettings.getter(ApplicationSettings::enabled)).setter(ApplicationSettings.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<String> SETTINGS_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ApplicationSettings.getter(ApplicationSettings::settingsGroup)).setter(ApplicationSettings.setter(Builder::settingsGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SettingsGroup").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, SETTINGS_GROUP_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final String settingsGroup;

    private ApplicationSettings(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.settingsGroup = builder.settingsGroup;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public String settingsGroup() {
        return this.settingsGroup;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.settingsGroup());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationSettings)) {
            return false;
        }
        ApplicationSettings other = (ApplicationSettings)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.settingsGroup(), other.settingsGroup());
    }

    public String toString() {
        return ToString.builder((String)"ApplicationSettings").add("Enabled", (Object)this.enabled()).add("SettingsGroup", (Object)this.settingsGroup()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "SettingsGroup": {
                return Optional.ofNullable(clazz.cast(this.settingsGroup()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationSettings, T> g) {
        return obj -> g.apply((ApplicationSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private String settingsGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationSettings model) {
            this.enabled(model.enabled);
            this.settingsGroup(model.settingsGroup);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getSettingsGroup() {
            return this.settingsGroup;
        }

        @Override
        public final Builder settingsGroup(String settingsGroup) {
            this.settingsGroup = settingsGroup;
            return this;
        }

        public final void setSettingsGroup(String settingsGroup) {
            this.settingsGroup = settingsGroup;
        }

        public ApplicationSettings build() {
            return new ApplicationSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationSettings> {
        public Builder enabled(Boolean var1);

        public Builder settingsGroup(String var1);
    }
}

