/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appstream.model.AppStreamRequest;
import software.amazon.awssdk.services.appstream.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateSoftwareToImageBuilderRequest
extends AppStreamRequest
implements ToCopyableBuilder<Builder, AssociateSoftwareToImageBuilderRequest> {
    private static final SdkField<String> IMAGE_BUILDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageBuilderName").getter(AssociateSoftwareToImageBuilderRequest.getter(AssociateSoftwareToImageBuilderRequest::imageBuilderName)).setter(AssociateSoftwareToImageBuilderRequest.setter(Builder::imageBuilderName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageBuilderName").build()}).build();
    private static final SdkField<List<String>> SOFTWARE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SoftwareNames").getter(AssociateSoftwareToImageBuilderRequest.getter(AssociateSoftwareToImageBuilderRequest::softwareNames)).setter(AssociateSoftwareToImageBuilderRequest.setter(Builder::softwareNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SoftwareNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_BUILDER_NAME_FIELD, SOFTWARE_NAMES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssociateSoftwareToImageBuilderRequest.memberNameToFieldInitializer();
    private final String imageBuilderName;
    private final List<String> softwareNames;

    private AssociateSoftwareToImageBuilderRequest(BuilderImpl builder) {
        super(builder);
        this.imageBuilderName = builder.imageBuilderName;
        this.softwareNames = builder.softwareNames;
    }

    public final String imageBuilderName() {
        return this.imageBuilderName;
    }

    public final boolean hasSoftwareNames() {
        return this.softwareNames != null && !(this.softwareNames instanceof SdkAutoConstructList);
    }

    public final List<String> softwareNames() {
        return this.softwareNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.imageBuilderName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSoftwareNames() ? this.softwareNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateSoftwareToImageBuilderRequest)) {
            return false;
        }
        AssociateSoftwareToImageBuilderRequest other = (AssociateSoftwareToImageBuilderRequest)((Object)obj);
        return Objects.equals(this.imageBuilderName(), other.imageBuilderName()) && this.hasSoftwareNames() == other.hasSoftwareNames() && Objects.equals(this.softwareNames(), other.softwareNames());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateSoftwareToImageBuilderRequest").add("ImageBuilderName", (Object)this.imageBuilderName()).add("SoftwareNames", this.hasSoftwareNames() ? this.softwareNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImageBuilderName": {
                return Optional.ofNullable(clazz.cast(this.imageBuilderName()));
            }
            case "SoftwareNames": {
                return Optional.ofNullable(clazz.cast(this.softwareNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ImageBuilderName", IMAGE_BUILDER_NAME_FIELD);
        map.put("SoftwareNames", SOFTWARE_NAMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateSoftwareToImageBuilderRequest, T> g) {
        return obj -> g.apply((AssociateSoftwareToImageBuilderRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppStreamRequest.BuilderImpl
    implements Builder {
        private String imageBuilderName;
        private List<String> softwareNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateSoftwareToImageBuilderRequest model) {
            super(model);
            this.imageBuilderName(model.imageBuilderName);
            this.softwareNames(model.softwareNames);
        }

        public final String getImageBuilderName() {
            return this.imageBuilderName;
        }

        public final void setImageBuilderName(String imageBuilderName) {
            this.imageBuilderName = imageBuilderName;
        }

        @Override
        public final Builder imageBuilderName(String imageBuilderName) {
            this.imageBuilderName = imageBuilderName;
            return this;
        }

        public final Collection<String> getSoftwareNames() {
            if (this.softwareNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.softwareNames;
        }

        public final void setSoftwareNames(Collection<String> softwareNames) {
            this.softwareNames = StringListCopier.copy(softwareNames);
        }

        @Override
        public final Builder softwareNames(Collection<String> softwareNames) {
            this.softwareNames = StringListCopier.copy(softwareNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder softwareNames(String ... softwareNames) {
            this.softwareNames(Arrays.asList(softwareNames));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateSoftwareToImageBuilderRequest build() {
            return new AssociateSoftwareToImageBuilderRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AppStreamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateSoftwareToImageBuilderRequest> {
        public Builder imageBuilderName(String var1);

        public Builder softwareNames(Collection<String> var1);

        public Builder softwareNames(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

