/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appstream.model.AdminAppLicenseUsageListCopier;
import software.amazon.awssdk.services.appstream.model.AdminAppLicenseUsageRecord;
import software.amazon.awssdk.services.appstream.model.AppStreamResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAppLicenseUsageResponse
extends AppStreamResponse
implements ToCopyableBuilder<Builder, DescribeAppLicenseUsageResponse> {
    private static final SdkField<List<AdminAppLicenseUsageRecord>> APP_LICENSE_USAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AppLicenseUsages").getter(DescribeAppLicenseUsageResponse.getter(DescribeAppLicenseUsageResponse::appLicenseUsages)).setter(DescribeAppLicenseUsageResponse.setter(Builder::appLicenseUsages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppLicenseUsages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AdminAppLicenseUsageRecord::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeAppLicenseUsageResponse.getter(DescribeAppLicenseUsageResponse::nextToken)).setter(DescribeAppLicenseUsageResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_LICENSE_USAGES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeAppLicenseUsageResponse.memberNameToFieldInitializer();
    private final List<AdminAppLicenseUsageRecord> appLicenseUsages;
    private final String nextToken;

    private DescribeAppLicenseUsageResponse(BuilderImpl builder) {
        super(builder);
        this.appLicenseUsages = builder.appLicenseUsages;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAppLicenseUsages() {
        return this.appLicenseUsages != null && !(this.appLicenseUsages instanceof SdkAutoConstructList);
    }

    public final List<AdminAppLicenseUsageRecord> appLicenseUsages() {
        return this.appLicenseUsages;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAppLicenseUsages() ? this.appLicenseUsages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAppLicenseUsageResponse)) {
            return false;
        }
        DescribeAppLicenseUsageResponse other = (DescribeAppLicenseUsageResponse)((Object)obj);
        return this.hasAppLicenseUsages() == other.hasAppLicenseUsages() && Objects.equals(this.appLicenseUsages(), other.appLicenseUsages()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAppLicenseUsageResponse").add("AppLicenseUsages", this.hasAppLicenseUsages() ? this.appLicenseUsages() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppLicenseUsages": {
                return Optional.ofNullable(clazz.cast(this.appLicenseUsages()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AppLicenseUsages", APP_LICENSE_USAGES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAppLicenseUsageResponse, T> g) {
        return obj -> g.apply((DescribeAppLicenseUsageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppStreamResponse.BuilderImpl
    implements Builder {
        private List<AdminAppLicenseUsageRecord> appLicenseUsages = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAppLicenseUsageResponse model) {
            super(model);
            this.appLicenseUsages(model.appLicenseUsages);
            this.nextToken(model.nextToken);
        }

        public final List<AdminAppLicenseUsageRecord.Builder> getAppLicenseUsages() {
            List<AdminAppLicenseUsageRecord.Builder> result = AdminAppLicenseUsageListCopier.copyToBuilder(this.appLicenseUsages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAppLicenseUsages(Collection<AdminAppLicenseUsageRecord.BuilderImpl> appLicenseUsages) {
            this.appLicenseUsages = AdminAppLicenseUsageListCopier.copyFromBuilder(appLicenseUsages);
        }

        @Override
        public final Builder appLicenseUsages(Collection<AdminAppLicenseUsageRecord> appLicenseUsages) {
            this.appLicenseUsages = AdminAppLicenseUsageListCopier.copy(appLicenseUsages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appLicenseUsages(AdminAppLicenseUsageRecord ... appLicenseUsages) {
            this.appLicenseUsages(Arrays.asList(appLicenseUsages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appLicenseUsages(Consumer<AdminAppLicenseUsageRecord.Builder> ... appLicenseUsages) {
            this.appLicenseUsages(Stream.of(appLicenseUsages).map(c -> (AdminAppLicenseUsageRecord)((AdminAppLicenseUsageRecord.Builder)AdminAppLicenseUsageRecord.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeAppLicenseUsageResponse build() {
            return new DescribeAppLicenseUsageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AppStreamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAppLicenseUsageResponse> {
        public Builder appLicenseUsages(Collection<AdminAppLicenseUsageRecord> var1);

        public Builder appLicenseUsages(AdminAppLicenseUsageRecord ... var1);

        public Builder appLicenseUsages(Consumer<AdminAppLicenseUsageRecord.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

