/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appstream.model.AppStreamRequest;
import software.amazon.awssdk.services.appstream.model.AwsAccountIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeImagePermissionsRequest
extends AppStreamRequest
implements ToCopyableBuilder<Builder, DescribeImagePermissionsRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DescribeImagePermissionsRequest.getter(DescribeImagePermissionsRequest::name)).setter(DescribeImagePermissionsRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeImagePermissionsRequest.getter(DescribeImagePermissionsRequest::maxResults)).setter(DescribeImagePermissionsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<List<String>> SHARED_AWS_ACCOUNT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SharedAwsAccountIds").getter(DescribeImagePermissionsRequest.getter(DescribeImagePermissionsRequest::sharedAwsAccountIds)).setter(DescribeImagePermissionsRequest.setter(Builder::sharedAwsAccountIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedAwsAccountIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeImagePermissionsRequest.getter(DescribeImagePermissionsRequest::nextToken)).setter(DescribeImagePermissionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, MAX_RESULTS_FIELD, SHARED_AWS_ACCOUNT_IDS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeImagePermissionsRequest.memberNameToFieldInitializer();
    private final String name;
    private final Integer maxResults;
    private final List<String> sharedAwsAccountIds;
    private final String nextToken;

    private DescribeImagePermissionsRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.maxResults = builder.maxResults;
        this.sharedAwsAccountIds = builder.sharedAwsAccountIds;
        this.nextToken = builder.nextToken;
    }

    public final String name() {
        return this.name;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final boolean hasSharedAwsAccountIds() {
        return this.sharedAwsAccountIds != null && !(this.sharedAwsAccountIds instanceof SdkAutoConstructList);
    }

    public final List<String> sharedAwsAccountIds() {
        return this.sharedAwsAccountIds;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSharedAwsAccountIds() ? this.sharedAwsAccountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImagePermissionsRequest)) {
            return false;
        }
        DescribeImagePermissionsRequest other = (DescribeImagePermissionsRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.maxResults(), other.maxResults()) && this.hasSharedAwsAccountIds() == other.hasSharedAwsAccountIds() && Objects.equals(this.sharedAwsAccountIds(), other.sharedAwsAccountIds()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeImagePermissionsRequest").add("Name", (Object)this.name()).add("MaxResults", (Object)this.maxResults()).add("SharedAwsAccountIds", this.hasSharedAwsAccountIds() ? this.sharedAwsAccountIds() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "SharedAwsAccountIds": {
                return Optional.ofNullable(clazz.cast(this.sharedAwsAccountIds()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("SharedAwsAccountIds", SHARED_AWS_ACCOUNT_IDS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeImagePermissionsRequest, T> g) {
        return obj -> g.apply((DescribeImagePermissionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppStreamRequest.BuilderImpl
    implements Builder {
        private String name;
        private Integer maxResults;
        private List<String> sharedAwsAccountIds = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImagePermissionsRequest model) {
            super(model);
            this.name(model.name);
            this.maxResults(model.maxResults);
            this.sharedAwsAccountIds(model.sharedAwsAccountIds);
            this.nextToken(model.nextToken);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Collection<String> getSharedAwsAccountIds() {
            if (this.sharedAwsAccountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sharedAwsAccountIds;
        }

        public final void setSharedAwsAccountIds(Collection<String> sharedAwsAccountIds) {
            this.sharedAwsAccountIds = AwsAccountIdListCopier.copy(sharedAwsAccountIds);
        }

        @Override
        public final Builder sharedAwsAccountIds(Collection<String> sharedAwsAccountIds) {
            this.sharedAwsAccountIds = AwsAccountIdListCopier.copy(sharedAwsAccountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sharedAwsAccountIds(String ... sharedAwsAccountIds) {
            this.sharedAwsAccountIds(Arrays.asList(sharedAwsAccountIds));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeImagePermissionsRequest build() {
            return new DescribeImagePermissionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AppStreamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeImagePermissionsRequest> {
        public Builder name(String var1);

        public Builder maxResults(Integer var1);

        public Builder sharedAwsAccountIds(Collection<String> var1);

        public Builder sharedAwsAccountIds(String ... var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

