/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appstream.model.AppBlockBuilder;
import software.amazon.awssdk.services.appstream.model.AppBlockBuilderListCopier;
import software.amazon.awssdk.services.appstream.model.AppStreamResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAppBlockBuildersResponse
extends AppStreamResponse
implements ToCopyableBuilder<Builder, DescribeAppBlockBuildersResponse> {
    private static final SdkField<List<AppBlockBuilder>> APP_BLOCK_BUILDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AppBlockBuilders").getter(DescribeAppBlockBuildersResponse.getter(DescribeAppBlockBuildersResponse::appBlockBuilders)).setter(DescribeAppBlockBuildersResponse.setter(Builder::appBlockBuilders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppBlockBuilders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AppBlockBuilder::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeAppBlockBuildersResponse.getter(DescribeAppBlockBuildersResponse::nextToken)).setter(DescribeAppBlockBuildersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_BLOCK_BUILDERS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeAppBlockBuildersResponse.memberNameToFieldInitializer();
    private final List<AppBlockBuilder> appBlockBuilders;
    private final String nextToken;

    private DescribeAppBlockBuildersResponse(BuilderImpl builder) {
        super(builder);
        this.appBlockBuilders = builder.appBlockBuilders;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAppBlockBuilders() {
        return this.appBlockBuilders != null && !(this.appBlockBuilders instanceof SdkAutoConstructList);
    }

    public final List<AppBlockBuilder> appBlockBuilders() {
        return this.appBlockBuilders;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAppBlockBuilders() ? this.appBlockBuilders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAppBlockBuildersResponse)) {
            return false;
        }
        DescribeAppBlockBuildersResponse other = (DescribeAppBlockBuildersResponse)((Object)obj);
        return this.hasAppBlockBuilders() == other.hasAppBlockBuilders() && Objects.equals(this.appBlockBuilders(), other.appBlockBuilders()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAppBlockBuildersResponse").add("AppBlockBuilders", this.hasAppBlockBuilders() ? this.appBlockBuilders() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppBlockBuilders": {
                return Optional.ofNullable(clazz.cast(this.appBlockBuilders()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AppBlockBuilders", APP_BLOCK_BUILDERS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAppBlockBuildersResponse, T> g) {
        return obj -> g.apply((DescribeAppBlockBuildersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppStreamResponse.BuilderImpl
    implements Builder {
        private List<AppBlockBuilder> appBlockBuilders = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAppBlockBuildersResponse model) {
            super(model);
            this.appBlockBuilders(model.appBlockBuilders);
            this.nextToken(model.nextToken);
        }

        public final List<AppBlockBuilder.Builder> getAppBlockBuilders() {
            List<AppBlockBuilder.Builder> result = AppBlockBuilderListCopier.copyToBuilder(this.appBlockBuilders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAppBlockBuilders(Collection<AppBlockBuilder.BuilderImpl> appBlockBuilders) {
            this.appBlockBuilders = AppBlockBuilderListCopier.copyFromBuilder(appBlockBuilders);
        }

        @Override
        public final Builder appBlockBuilders(Collection<AppBlockBuilder> appBlockBuilders) {
            this.appBlockBuilders = AppBlockBuilderListCopier.copy(appBlockBuilders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appBlockBuilders(AppBlockBuilder ... appBlockBuilders) {
            this.appBlockBuilders(Arrays.asList(appBlockBuilders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appBlockBuilders(Consumer<AppBlockBuilder.Builder> ... appBlockBuilders) {
            this.appBlockBuilders(Stream.of(appBlockBuilders).map(c -> (AppBlockBuilder)((AppBlockBuilder.Builder)AppBlockBuilder.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeAppBlockBuildersResponse build() {
            return new DescribeAppBlockBuildersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AppStreamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAppBlockBuildersResponse> {
        public Builder appBlockBuilders(Collection<AppBlockBuilder> var1);

        public Builder appBlockBuilders(AppBlockBuilder ... var1);

        public Builder appBlockBuilders(Consumer<AppBlockBuilder.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

