/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appstream.model.AppStreamRequest;
import software.amazon.awssdk.services.appstream.model.CertificateBasedAuthProperties;
import software.amazon.awssdk.services.appstream.model.OrganizationalUnitDistinguishedNamesListCopier;
import software.amazon.awssdk.services.appstream.model.ServiceAccountCredentials;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDirectoryConfigRequest
extends AppStreamRequest
implements ToCopyableBuilder<Builder, CreateDirectoryConfigRequest> {
    private static final SdkField<String> DIRECTORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryName").getter(CreateDirectoryConfigRequest.getter(CreateDirectoryConfigRequest::directoryName)).setter(CreateDirectoryConfigRequest.setter(Builder::directoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryName").build()}).build();
    private static final SdkField<List<String>> ORGANIZATIONAL_UNIT_DISTINGUISHED_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OrganizationalUnitDistinguishedNames").getter(CreateDirectoryConfigRequest.getter(CreateDirectoryConfigRequest::organizationalUnitDistinguishedNames)).setter(CreateDirectoryConfigRequest.setter(Builder::organizationalUnitDistinguishedNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationalUnitDistinguishedNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ServiceAccountCredentials> SERVICE_ACCOUNT_CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServiceAccountCredentials").getter(CreateDirectoryConfigRequest.getter(CreateDirectoryConfigRequest::serviceAccountCredentials)).setter(CreateDirectoryConfigRequest.setter(Builder::serviceAccountCredentials)).constructor(ServiceAccountCredentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceAccountCredentials").build()}).build();
    private static final SdkField<CertificateBasedAuthProperties> CERTIFICATE_BASED_AUTH_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CertificateBasedAuthProperties").getter(CreateDirectoryConfigRequest.getter(CreateDirectoryConfigRequest::certificateBasedAuthProperties)).setter(CreateDirectoryConfigRequest.setter(Builder::certificateBasedAuthProperties)).constructor(CertificateBasedAuthProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateBasedAuthProperties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_NAME_FIELD, ORGANIZATIONAL_UNIT_DISTINGUISHED_NAMES_FIELD, SERVICE_ACCOUNT_CREDENTIALS_FIELD, CERTIFICATE_BASED_AUTH_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDirectoryConfigRequest.memberNameToFieldInitializer();
    private final String directoryName;
    private final List<String> organizationalUnitDistinguishedNames;
    private final ServiceAccountCredentials serviceAccountCredentials;
    private final CertificateBasedAuthProperties certificateBasedAuthProperties;

    private CreateDirectoryConfigRequest(BuilderImpl builder) {
        super(builder);
        this.directoryName = builder.directoryName;
        this.organizationalUnitDistinguishedNames = builder.organizationalUnitDistinguishedNames;
        this.serviceAccountCredentials = builder.serviceAccountCredentials;
        this.certificateBasedAuthProperties = builder.certificateBasedAuthProperties;
    }

    public final String directoryName() {
        return this.directoryName;
    }

    public final boolean hasOrganizationalUnitDistinguishedNames() {
        return this.organizationalUnitDistinguishedNames != null && !(this.organizationalUnitDistinguishedNames instanceof SdkAutoConstructList);
    }

    public final List<String> organizationalUnitDistinguishedNames() {
        return this.organizationalUnitDistinguishedNames;
    }

    public final ServiceAccountCredentials serviceAccountCredentials() {
        return this.serviceAccountCredentials;
    }

    public final CertificateBasedAuthProperties certificateBasedAuthProperties() {
        return this.certificateBasedAuthProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrganizationalUnitDistinguishedNames() ? this.organizationalUnitDistinguishedNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAccountCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateBasedAuthProperties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDirectoryConfigRequest)) {
            return false;
        }
        CreateDirectoryConfigRequest other = (CreateDirectoryConfigRequest)((Object)obj);
        return Objects.equals(this.directoryName(), other.directoryName()) && this.hasOrganizationalUnitDistinguishedNames() == other.hasOrganizationalUnitDistinguishedNames() && Objects.equals(this.organizationalUnitDistinguishedNames(), other.organizationalUnitDistinguishedNames()) && Objects.equals(this.serviceAccountCredentials(), other.serviceAccountCredentials()) && Objects.equals(this.certificateBasedAuthProperties(), other.certificateBasedAuthProperties());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDirectoryConfigRequest").add("DirectoryName", (Object)this.directoryName()).add("OrganizationalUnitDistinguishedNames", this.hasOrganizationalUnitDistinguishedNames() ? this.organizationalUnitDistinguishedNames() : null).add("ServiceAccountCredentials", (Object)this.serviceAccountCredentials()).add("CertificateBasedAuthProperties", (Object)this.certificateBasedAuthProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryName": {
                return Optional.ofNullable(clazz.cast(this.directoryName()));
            }
            case "OrganizationalUnitDistinguishedNames": {
                return Optional.ofNullable(clazz.cast(this.organizationalUnitDistinguishedNames()));
            }
            case "ServiceAccountCredentials": {
                return Optional.ofNullable(clazz.cast(this.serviceAccountCredentials()));
            }
            case "CertificateBasedAuthProperties": {
                return Optional.ofNullable(clazz.cast(this.certificateBasedAuthProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DirectoryName", DIRECTORY_NAME_FIELD);
        map.put("OrganizationalUnitDistinguishedNames", ORGANIZATIONAL_UNIT_DISTINGUISHED_NAMES_FIELD);
        map.put("ServiceAccountCredentials", SERVICE_ACCOUNT_CREDENTIALS_FIELD);
        map.put("CertificateBasedAuthProperties", CERTIFICATE_BASED_AUTH_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDirectoryConfigRequest, T> g) {
        return obj -> g.apply((CreateDirectoryConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppStreamRequest.BuilderImpl
    implements Builder {
        private String directoryName;
        private List<String> organizationalUnitDistinguishedNames = DefaultSdkAutoConstructList.getInstance();
        private ServiceAccountCredentials serviceAccountCredentials;
        private CertificateBasedAuthProperties certificateBasedAuthProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDirectoryConfigRequest model) {
            super(model);
            this.directoryName(model.directoryName);
            this.organizationalUnitDistinguishedNames(model.organizationalUnitDistinguishedNames);
            this.serviceAccountCredentials(model.serviceAccountCredentials);
            this.certificateBasedAuthProperties(model.certificateBasedAuthProperties);
        }

        public final String getDirectoryName() {
            return this.directoryName;
        }

        public final void setDirectoryName(String directoryName) {
            this.directoryName = directoryName;
        }

        @Override
        public final Builder directoryName(String directoryName) {
            this.directoryName = directoryName;
            return this;
        }

        public final Collection<String> getOrganizationalUnitDistinguishedNames() {
            if (this.organizationalUnitDistinguishedNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.organizationalUnitDistinguishedNames;
        }

        public final void setOrganizationalUnitDistinguishedNames(Collection<String> organizationalUnitDistinguishedNames) {
            this.organizationalUnitDistinguishedNames = OrganizationalUnitDistinguishedNamesListCopier.copy(organizationalUnitDistinguishedNames);
        }

        @Override
        public final Builder organizationalUnitDistinguishedNames(Collection<String> organizationalUnitDistinguishedNames) {
            this.organizationalUnitDistinguishedNames = OrganizationalUnitDistinguishedNamesListCopier.copy(organizationalUnitDistinguishedNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationalUnitDistinguishedNames(String ... organizationalUnitDistinguishedNames) {
            this.organizationalUnitDistinguishedNames(Arrays.asList(organizationalUnitDistinguishedNames));
            return this;
        }

        public final ServiceAccountCredentials.Builder getServiceAccountCredentials() {
            return this.serviceAccountCredentials != null ? this.serviceAccountCredentials.toBuilder() : null;
        }

        public final void setServiceAccountCredentials(ServiceAccountCredentials.BuilderImpl serviceAccountCredentials) {
            this.serviceAccountCredentials = serviceAccountCredentials != null ? serviceAccountCredentials.build() : null;
        }

        @Override
        public final Builder serviceAccountCredentials(ServiceAccountCredentials serviceAccountCredentials) {
            this.serviceAccountCredentials = serviceAccountCredentials;
            return this;
        }

        public final CertificateBasedAuthProperties.Builder getCertificateBasedAuthProperties() {
            return this.certificateBasedAuthProperties != null ? this.certificateBasedAuthProperties.toBuilder() : null;
        }

        public final void setCertificateBasedAuthProperties(CertificateBasedAuthProperties.BuilderImpl certificateBasedAuthProperties) {
            this.certificateBasedAuthProperties = certificateBasedAuthProperties != null ? certificateBasedAuthProperties.build() : null;
        }

        @Override
        public final Builder certificateBasedAuthProperties(CertificateBasedAuthProperties certificateBasedAuthProperties) {
            this.certificateBasedAuthProperties = certificateBasedAuthProperties;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDirectoryConfigRequest build() {
            return new CreateDirectoryConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AppStreamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDirectoryConfigRequest> {
        public Builder directoryName(String var1);

        public Builder organizationalUnitDistinguishedNames(Collection<String> var1);

        public Builder organizationalUnitDistinguishedNames(String ... var1);

        public Builder serviceAccountCredentials(ServiceAccountCredentials var1);

        default public Builder serviceAccountCredentials(Consumer<ServiceAccountCredentials.Builder> serviceAccountCredentials) {
            return this.serviceAccountCredentials((ServiceAccountCredentials)((ServiceAccountCredentials.Builder)ServiceAccountCredentials.builder().applyMutation(serviceAccountCredentials)).build());
        }

        public Builder certificateBasedAuthProperties(CertificateBasedAuthProperties var1);

        default public Builder certificateBasedAuthProperties(Consumer<CertificateBasedAuthProperties.Builder> certificateBasedAuthProperties) {
            return this.certificateBasedAuthProperties((CertificateBasedAuthProperties)((CertificateBasedAuthProperties.Builder)CertificateBasedAuthProperties.builder().applyMutation(certificateBasedAuthProperties)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

