/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appstream.model.AppStreamResponse;
import software.amazon.awssdk.services.appstream.model.UsageReportSchedule;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateUsageReportSubscriptionResponse
extends AppStreamResponse
implements ToCopyableBuilder<Builder, CreateUsageReportSubscriptionResponse> {
    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BucketName").getter(CreateUsageReportSubscriptionResponse.getter(CreateUsageReportSubscriptionResponse::s3BucketName)).setter(CreateUsageReportSubscriptionResponse.setter(Builder::s3BucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()}).build();
    private static final SdkField<String> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Schedule").getter(CreateUsageReportSubscriptionResponse.getter(CreateUsageReportSubscriptionResponse::scheduleAsString)).setter(CreateUsageReportSubscriptionResponse.setter(Builder::schedule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_NAME_FIELD, SCHEDULE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateUsageReportSubscriptionResponse.memberNameToFieldInitializer();
    private final String s3BucketName;
    private final String schedule;

    private CreateUsageReportSubscriptionResponse(BuilderImpl builder) {
        super(builder);
        this.s3BucketName = builder.s3BucketName;
        this.schedule = builder.schedule;
    }

    public final String s3BucketName() {
        return this.s3BucketName;
    }

    public final UsageReportSchedule schedule() {
        return UsageReportSchedule.fromValue(this.schedule);
    }

    public final String scheduleAsString() {
        return this.schedule;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUsageReportSubscriptionResponse)) {
            return false;
        }
        CreateUsageReportSubscriptionResponse other = (CreateUsageReportSubscriptionResponse)((Object)obj);
        return Objects.equals(this.s3BucketName(), other.s3BucketName()) && Objects.equals(this.scheduleAsString(), other.scheduleAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateUsageReportSubscriptionResponse").add("S3BucketName", (Object)this.s3BucketName()).add("Schedule", (Object)this.scheduleAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3BucketName": {
                return Optional.ofNullable(clazz.cast(this.s3BucketName()));
            }
            case "Schedule": {
                return Optional.ofNullable(clazz.cast(this.scheduleAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("S3BucketName", S3_BUCKET_NAME_FIELD);
        map.put("Schedule", SCHEDULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateUsageReportSubscriptionResponse, T> g) {
        return obj -> g.apply((CreateUsageReportSubscriptionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppStreamResponse.BuilderImpl
    implements Builder {
        private String s3BucketName;
        private String schedule;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUsageReportSubscriptionResponse model) {
            super(model);
            this.s3BucketName(model.s3BucketName);
            this.schedule(model.schedule);
        }

        public final String getS3BucketName() {
            return this.s3BucketName;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final String getSchedule() {
            return this.schedule;
        }

        public final void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        @Override
        public final Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        @Override
        public final Builder schedule(UsageReportSchedule schedule) {
            this.schedule(schedule == null ? null : schedule.toString());
            return this;
        }

        @Override
        public CreateUsageReportSubscriptionResponse build() {
            return new CreateUsageReportSubscriptionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AppStreamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateUsageReportSubscriptionResponse> {
        public Builder s3BucketName(String var1);

        public Builder schedule(String var1);

        public Builder schedule(UsageReportSchedule var1);
    }
}

