/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appstream.model.Application;
import software.amazon.awssdk.services.appstream.model.ApplicationsCopier;
import software.amazon.awssdk.services.appstream.model.ImagePermissions;
import software.amazon.awssdk.services.appstream.model.ImageState;
import software.amazon.awssdk.services.appstream.model.ImageStateChangeReason;
import software.amazon.awssdk.services.appstream.model.PlatformType;
import software.amazon.awssdk.services.appstream.model.VisibilityType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Image
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Image> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Image.getter(Image::name)).setter(Image.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(Image.getter(Image::arn)).setter(Image.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> BASE_IMAGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaseImageArn").getter(Image.getter(Image::baseImageArn)).setter(Image.setter(Builder::baseImageArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseImageArn").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(Image.getter(Image::displayName)).setter(Image.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(Image.getter(Image::stateAsString)).setter(Image.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Visibility").getter(Image.getter(Image::visibilityAsString)).setter(Image.setter(Builder::visibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()}).build();
    private static final SdkField<Boolean> IMAGE_BUILDER_SUPPORTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ImageBuilderSupported").getter(Image.getter(Image::imageBuilderSupported)).setter(Image.setter(Builder::imageBuilderSupported)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageBuilderSupported").build()}).build();
    private static final SdkField<String> IMAGE_BUILDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageBuilderName").getter(Image.getter(Image::imageBuilderName)).setter(Image.setter(Builder::imageBuilderName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageBuilderName").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Platform").getter(Image.getter(Image::platformAsString)).setter(Image.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Image.getter(Image::description)).setter(Image.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<ImageStateChangeReason> STATE_CHANGE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StateChangeReason").getter(Image.getter(Image::stateChangeReason)).setter(Image.setter(Builder::stateChangeReason)).constructor(ImageStateChangeReason::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateChangeReason").build()}).build();
    private static final SdkField<List<Application>> APPLICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Applications").getter(Image.getter(Image::applications)).setter(Image.setter(Builder::applications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Applications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Application::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(Image.getter(Image::createdTime)).setter(Image.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<Instant> PUBLIC_BASE_IMAGE_RELEASED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("PublicBaseImageReleasedDate").getter(Image.getter(Image::publicBaseImageReleasedDate)).setter(Image.setter(Builder::publicBaseImageReleasedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicBaseImageReleasedDate").build()}).build();
    private static final SdkField<String> APPSTREAM_AGENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppstreamAgentVersion").getter(Image.getter(Image::appstreamAgentVersion)).setter(Image.setter(Builder::appstreamAgentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppstreamAgentVersion").build()}).build();
    private static final SdkField<ImagePermissions> IMAGE_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ImagePermissions").getter(Image.getter(Image::imagePermissions)).setter(Image.setter(Builder::imagePermissions)).constructor(ImagePermissions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImagePermissions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, BASE_IMAGE_ARN_FIELD, DISPLAY_NAME_FIELD, STATE_FIELD, VISIBILITY_FIELD, IMAGE_BUILDER_SUPPORTED_FIELD, IMAGE_BUILDER_NAME_FIELD, PLATFORM_FIELD, DESCRIPTION_FIELD, STATE_CHANGE_REASON_FIELD, APPLICATIONS_FIELD, CREATED_TIME_FIELD, PUBLIC_BASE_IMAGE_RELEASED_DATE_FIELD, APPSTREAM_AGENT_VERSION_FIELD, IMAGE_PERMISSIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final String baseImageArn;
    private final String displayName;
    private final String state;
    private final String visibility;
    private final Boolean imageBuilderSupported;
    private final String imageBuilderName;
    private final String platform;
    private final String description;
    private final ImageStateChangeReason stateChangeReason;
    private final List<Application> applications;
    private final Instant createdTime;
    private final Instant publicBaseImageReleasedDate;
    private final String appstreamAgentVersion;
    private final ImagePermissions imagePermissions;

    private Image(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.baseImageArn = builder.baseImageArn;
        this.displayName = builder.displayName;
        this.state = builder.state;
        this.visibility = builder.visibility;
        this.imageBuilderSupported = builder.imageBuilderSupported;
        this.imageBuilderName = builder.imageBuilderName;
        this.platform = builder.platform;
        this.description = builder.description;
        this.stateChangeReason = builder.stateChangeReason;
        this.applications = builder.applications;
        this.createdTime = builder.createdTime;
        this.publicBaseImageReleasedDate = builder.publicBaseImageReleasedDate;
        this.appstreamAgentVersion = builder.appstreamAgentVersion;
        this.imagePermissions = builder.imagePermissions;
    }

    public String name() {
        return this.name;
    }

    public String arn() {
        return this.arn;
    }

    public String baseImageArn() {
        return this.baseImageArn;
    }

    public String displayName() {
        return this.displayName;
    }

    public ImageState state() {
        return ImageState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public VisibilityType visibility() {
        return VisibilityType.fromValue(this.visibility);
    }

    public String visibilityAsString() {
        return this.visibility;
    }

    public Boolean imageBuilderSupported() {
        return this.imageBuilderSupported;
    }

    public String imageBuilderName() {
        return this.imageBuilderName;
    }

    public PlatformType platform() {
        return PlatformType.fromValue(this.platform);
    }

    public String platformAsString() {
        return this.platform;
    }

    public String description() {
        return this.description;
    }

    public ImageStateChangeReason stateChangeReason() {
        return this.stateChangeReason;
    }

    public boolean hasApplications() {
        return this.applications != null && !(this.applications instanceof SdkAutoConstructList);
    }

    public List<Application> applications() {
        return this.applications;
    }

    public Instant createdTime() {
        return this.createdTime;
    }

    public Instant publicBaseImageReleasedDate() {
        return this.publicBaseImageReleasedDate;
    }

    public String appstreamAgentVersion() {
        return this.appstreamAgentVersion;
    }

    public ImagePermissions imagePermissions() {
        return this.imagePermissions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseImageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageBuilderSupported());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageBuilderName());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateChangeReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplications() ? this.applications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicBaseImageReleasedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.appstreamAgentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.imagePermissions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Image)) {
            return false;
        }
        Image other = (Image)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.baseImageArn(), other.baseImageArn()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.visibilityAsString(), other.visibilityAsString()) && Objects.equals(this.imageBuilderSupported(), other.imageBuilderSupported()) && Objects.equals(this.imageBuilderName(), other.imageBuilderName()) && Objects.equals(this.platformAsString(), other.platformAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.stateChangeReason(), other.stateChangeReason()) && this.hasApplications() == other.hasApplications() && Objects.equals(this.applications(), other.applications()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.publicBaseImageReleasedDate(), other.publicBaseImageReleasedDate()) && Objects.equals(this.appstreamAgentVersion(), other.appstreamAgentVersion()) && Objects.equals(this.imagePermissions(), other.imagePermissions());
    }

    public String toString() {
        return ToString.builder((String)"Image").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("BaseImageArn", (Object)this.baseImageArn()).add("DisplayName", (Object)this.displayName()).add("State", (Object)this.stateAsString()).add("Visibility", (Object)this.visibilityAsString()).add("ImageBuilderSupported", (Object)this.imageBuilderSupported()).add("ImageBuilderName", (Object)this.imageBuilderName()).add("Platform", (Object)this.platformAsString()).add("Description", (Object)this.description()).add("StateChangeReason", (Object)this.stateChangeReason()).add("Applications", this.hasApplications() ? this.applications() : null).add("CreatedTime", (Object)this.createdTime()).add("PublicBaseImageReleasedDate", (Object)this.publicBaseImageReleasedDate()).add("AppstreamAgentVersion", (Object)this.appstreamAgentVersion()).add("ImagePermissions", (Object)this.imagePermissions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "BaseImageArn": {
                return Optional.ofNullable(clazz.cast(this.baseImageArn()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Visibility": {
                return Optional.ofNullable(clazz.cast(this.visibilityAsString()));
            }
            case "ImageBuilderSupported": {
                return Optional.ofNullable(clazz.cast(this.imageBuilderSupported()));
            }
            case "ImageBuilderName": {
                return Optional.ofNullable(clazz.cast(this.imageBuilderName()));
            }
            case "Platform": {
                return Optional.ofNullable(clazz.cast(this.platformAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "StateChangeReason": {
                return Optional.ofNullable(clazz.cast(this.stateChangeReason()));
            }
            case "Applications": {
                return Optional.ofNullable(clazz.cast(this.applications()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "PublicBaseImageReleasedDate": {
                return Optional.ofNullable(clazz.cast(this.publicBaseImageReleasedDate()));
            }
            case "AppstreamAgentVersion": {
                return Optional.ofNullable(clazz.cast(this.appstreamAgentVersion()));
            }
            case "ImagePermissions": {
                return Optional.ofNullable(clazz.cast(this.imagePermissions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Image, T> g) {
        return obj -> g.apply((Image)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String baseImageArn;
        private String displayName;
        private String state;
        private String visibility;
        private Boolean imageBuilderSupported;
        private String imageBuilderName;
        private String platform;
        private String description;
        private ImageStateChangeReason stateChangeReason;
        private List<Application> applications = DefaultSdkAutoConstructList.getInstance();
        private Instant createdTime;
        private Instant publicBaseImageReleasedDate;
        private String appstreamAgentVersion;
        private ImagePermissions imagePermissions;

        private BuilderImpl() {
        }

        private BuilderImpl(Image model) {
            this.name(model.name);
            this.arn(model.arn);
            this.baseImageArn(model.baseImageArn);
            this.displayName(model.displayName);
            this.state(model.state);
            this.visibility(model.visibility);
            this.imageBuilderSupported(model.imageBuilderSupported);
            this.imageBuilderName(model.imageBuilderName);
            this.platform(model.platform);
            this.description(model.description);
            this.stateChangeReason(model.stateChangeReason);
            this.applications(model.applications);
            this.createdTime(model.createdTime);
            this.publicBaseImageReleasedDate(model.publicBaseImageReleasedDate);
            this.appstreamAgentVersion(model.appstreamAgentVersion);
            this.imagePermissions(model.imagePermissions);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getBaseImageArn() {
            return this.baseImageArn;
        }

        @Override
        public final Builder baseImageArn(String baseImageArn) {
            this.baseImageArn = baseImageArn;
            return this;
        }

        public final void setBaseImageArn(String baseImageArn) {
            this.baseImageArn = baseImageArn;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ImageState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getVisibility() {
            return this.visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(VisibilityType visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        public final Boolean getImageBuilderSupported() {
            return this.imageBuilderSupported;
        }

        @Override
        public final Builder imageBuilderSupported(Boolean imageBuilderSupported) {
            this.imageBuilderSupported = imageBuilderSupported;
            return this;
        }

        public final void setImageBuilderSupported(Boolean imageBuilderSupported) {
            this.imageBuilderSupported = imageBuilderSupported;
        }

        public final String getImageBuilderName() {
            return this.imageBuilderName;
        }

        @Override
        public final Builder imageBuilderName(String imageBuilderName) {
            this.imageBuilderName = imageBuilderName;
            return this;
        }

        public final void setImageBuilderName(String imageBuilderName) {
            this.imageBuilderName = imageBuilderName;
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(PlatformType platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final ImageStateChangeReason.Builder getStateChangeReason() {
            return this.stateChangeReason != null ? this.stateChangeReason.toBuilder() : null;
        }

        @Override
        public final Builder stateChangeReason(ImageStateChangeReason stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
            return this;
        }

        public final void setStateChangeReason(ImageStateChangeReason.BuilderImpl stateChangeReason) {
            this.stateChangeReason = stateChangeReason != null ? stateChangeReason.build() : null;
        }

        public final Collection<Application.Builder> getApplications() {
            if (this.applications instanceof SdkAutoConstructList) {
                return null;
            }
            return this.applications != null ? (Collection)this.applications.stream().map(Application::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder applications(Collection<Application> applications) {
            this.applications = ApplicationsCopier.copy(applications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applications(Application ... applications) {
            this.applications(Arrays.asList(applications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applications(Consumer<Application.Builder> ... applications) {
            this.applications(Stream.of(applications).map(c -> (Application)((Application.Builder)Application.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setApplications(Collection<Application.BuilderImpl> applications) {
            this.applications = ApplicationsCopier.copyFromBuilder(applications);
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final Instant getPublicBaseImageReleasedDate() {
            return this.publicBaseImageReleasedDate;
        }

        @Override
        public final Builder publicBaseImageReleasedDate(Instant publicBaseImageReleasedDate) {
            this.publicBaseImageReleasedDate = publicBaseImageReleasedDate;
            return this;
        }

        public final void setPublicBaseImageReleasedDate(Instant publicBaseImageReleasedDate) {
            this.publicBaseImageReleasedDate = publicBaseImageReleasedDate;
        }

        public final String getAppstreamAgentVersion() {
            return this.appstreamAgentVersion;
        }

        @Override
        public final Builder appstreamAgentVersion(String appstreamAgentVersion) {
            this.appstreamAgentVersion = appstreamAgentVersion;
            return this;
        }

        public final void setAppstreamAgentVersion(String appstreamAgentVersion) {
            this.appstreamAgentVersion = appstreamAgentVersion;
        }

        public final ImagePermissions.Builder getImagePermissions() {
            return this.imagePermissions != null ? this.imagePermissions.toBuilder() : null;
        }

        @Override
        public final Builder imagePermissions(ImagePermissions imagePermissions) {
            this.imagePermissions = imagePermissions;
            return this;
        }

        public final void setImagePermissions(ImagePermissions.BuilderImpl imagePermissions) {
            this.imagePermissions = imagePermissions != null ? imagePermissions.build() : null;
        }

        public Image build() {
            return new Image(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Image> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder baseImageArn(String var1);

        public Builder displayName(String var1);

        public Builder state(String var1);

        public Builder state(ImageState var1);

        public Builder visibility(String var1);

        public Builder visibility(VisibilityType var1);

        public Builder imageBuilderSupported(Boolean var1);

        public Builder imageBuilderName(String var1);

        public Builder platform(String var1);

        public Builder platform(PlatformType var1);

        public Builder description(String var1);

        public Builder stateChangeReason(ImageStateChangeReason var1);

        default public Builder stateChangeReason(Consumer<ImageStateChangeReason.Builder> stateChangeReason) {
            return this.stateChangeReason((ImageStateChangeReason)((ImageStateChangeReason.Builder)ImageStateChangeReason.builder().applyMutation(stateChangeReason)).build());
        }

        public Builder applications(Collection<Application> var1);

        public Builder applications(Application ... var1);

        public Builder applications(Consumer<Application.Builder> ... var1);

        public Builder createdTime(Instant var1);

        public Builder publicBaseImageReleasedDate(Instant var1);

        public Builder appstreamAgentVersion(String var1);

        public Builder imagePermissions(ImagePermissions var1);

        default public Builder imagePermissions(Consumer<ImagePermissions.Builder> imagePermissions) {
            return this.imagePermissions((ImagePermissions)((ImagePermissions.Builder)ImagePermissions.builder().applyMutation(imagePermissions)).build());
        }
    }
}

