/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appstream.model.AppStreamResponse;
import software.amazon.awssdk.services.appstream.model.SharedImagePermissions;
import software.amazon.awssdk.services.appstream.model.SharedImagePermissionsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeImagePermissionsResponse
extends AppStreamResponse
implements ToCopyableBuilder<Builder, DescribeImagePermissionsResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeImagePermissionsResponse.getter(DescribeImagePermissionsResponse::name)).setter(DescribeImagePermissionsResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<SharedImagePermissions>> SHARED_IMAGE_PERMISSIONS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeImagePermissionsResponse.getter(DescribeImagePermissionsResponse::sharedImagePermissionsList)).setter(DescribeImagePermissionsResponse.setter(Builder::sharedImagePermissionsList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedImagePermissionsList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SharedImagePermissions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeImagePermissionsResponse.getter(DescribeImagePermissionsResponse::nextToken)).setter(DescribeImagePermissionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SHARED_IMAGE_PERMISSIONS_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final String name;
    private final List<SharedImagePermissions> sharedImagePermissionsList;
    private final String nextToken;

    private DescribeImagePermissionsResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.sharedImagePermissionsList = builder.sharedImagePermissionsList;
        this.nextToken = builder.nextToken;
    }

    public String name() {
        return this.name;
    }

    public boolean hasSharedImagePermissionsList() {
        return this.sharedImagePermissionsList != null && !(this.sharedImagePermissionsList instanceof SdkAutoConstructList);
    }

    public List<SharedImagePermissions> sharedImagePermissionsList() {
        return this.sharedImagePermissionsList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.sharedImagePermissionsList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImagePermissionsResponse)) {
            return false;
        }
        DescribeImagePermissionsResponse other = (DescribeImagePermissionsResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.sharedImagePermissionsList(), other.sharedImagePermissionsList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeImagePermissionsResponse").add("Name", (Object)this.name()).add("SharedImagePermissionsList", this.sharedImagePermissionsList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "SharedImagePermissionsList": {
                return Optional.ofNullable(clazz.cast(this.sharedImagePermissionsList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeImagePermissionsResponse, T> g) {
        return obj -> g.apply((DescribeImagePermissionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppStreamResponse.BuilderImpl
    implements Builder {
        private String name;
        private List<SharedImagePermissions> sharedImagePermissionsList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImagePermissionsResponse model) {
            super(model);
            this.name(model.name);
            this.sharedImagePermissionsList(model.sharedImagePermissionsList);
            this.nextToken(model.nextToken);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<SharedImagePermissions.Builder> getSharedImagePermissionsList() {
            return this.sharedImagePermissionsList != null ? (Collection)this.sharedImagePermissionsList.stream().map(SharedImagePermissions::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sharedImagePermissionsList(Collection<SharedImagePermissions> sharedImagePermissionsList) {
            this.sharedImagePermissionsList = SharedImagePermissionsListCopier.copy(sharedImagePermissionsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sharedImagePermissionsList(SharedImagePermissions ... sharedImagePermissionsList) {
            this.sharedImagePermissionsList(Arrays.asList(sharedImagePermissionsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sharedImagePermissionsList(Consumer<SharedImagePermissions.Builder> ... sharedImagePermissionsList) {
            this.sharedImagePermissionsList(Stream.of(sharedImagePermissionsList).map(c -> (SharedImagePermissions)((SharedImagePermissions.Builder)SharedImagePermissions.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSharedImagePermissionsList(Collection<SharedImagePermissions.BuilderImpl> sharedImagePermissionsList) {
            this.sharedImagePermissionsList = SharedImagePermissionsListCopier.copyFromBuilder(sharedImagePermissionsList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeImagePermissionsResponse build() {
            return new DescribeImagePermissionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppStreamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeImagePermissionsResponse> {
        public Builder name(String var1);

        public Builder sharedImagePermissionsList(Collection<SharedImagePermissions> var1);

        public Builder sharedImagePermissionsList(SharedImagePermissions ... var1);

        public Builder sharedImagePermissionsList(Consumer<SharedImagePermissions.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

