/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.transform.ServiceAccountCredentialsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ServiceAccountCredentials
implements StructuredPojo,
ToCopyableBuilder<Builder, ServiceAccountCredentials> {
    private final String accountName;
    private final String accountPassword;

    private ServiceAccountCredentials(BuilderImpl builder) {
        this.accountName = builder.accountName;
        this.accountPassword = builder.accountPassword;
    }

    public String accountName() {
        return this.accountName;
    }

    public String accountPassword() {
        return this.accountPassword;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountName());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountPassword());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceAccountCredentials)) {
            return false;
        }
        ServiceAccountCredentials other = (ServiceAccountCredentials)obj;
        return Objects.equals(this.accountName(), other.accountName()) && Objects.equals(this.accountPassword(), other.accountPassword());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.accountName() != null) {
            sb.append("AccountName: ").append(this.accountName()).append(",");
        }
        if (this.accountPassword() != null) {
            sb.append("AccountPassword: ").append(this.accountPassword()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountName": {
                return Optional.of(clazz.cast(this.accountName()));
            }
            case "AccountPassword": {
                return Optional.of(clazz.cast(this.accountPassword()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ServiceAccountCredentialsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountName;
        private String accountPassword;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceAccountCredentials model) {
            this.accountName(model.accountName);
            this.accountPassword(model.accountPassword);
        }

        public final String getAccountName() {
            return this.accountName;
        }

        @Override
        public final Builder accountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        public final void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        public final String getAccountPassword() {
            return this.accountPassword;
        }

        @Override
        public final Builder accountPassword(String accountPassword) {
            this.accountPassword = accountPassword;
            return this;
        }

        public final void setAccountPassword(String accountPassword) {
            this.accountPassword = accountPassword;
        }

        public ServiceAccountCredentials build() {
            return new ServiceAccountCredentials(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ServiceAccountCredentials> {
        public Builder accountName(String var1);

        public Builder accountPassword(String var1);
    }
}

