/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.model.Application;
import software.amazon.awssdk.services.appstream.model.ApplicationsCopier;
import software.amazon.awssdk.services.appstream.model.ImageState;
import software.amazon.awssdk.services.appstream.model.ImageStateChangeReason;
import software.amazon.awssdk.services.appstream.model.PlatformType;
import software.amazon.awssdk.services.appstream.model.VisibilityType;
import software.amazon.awssdk.services.appstream.transform.ImageMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Image
implements StructuredPojo,
ToCopyableBuilder<Builder, Image> {
    private final String name;
    private final String arn;
    private final String baseImageArn;
    private final String displayName;
    private final String state;
    private final String visibility;
    private final Boolean imageBuilderSupported;
    private final String platform;
    private final String description;
    private final ImageStateChangeReason stateChangeReason;
    private final List<Application> applications;
    private final Instant createdTime;
    private final Instant publicBaseImageReleasedDate;

    private Image(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.baseImageArn = builder.baseImageArn;
        this.displayName = builder.displayName;
        this.state = builder.state;
        this.visibility = builder.visibility;
        this.imageBuilderSupported = builder.imageBuilderSupported;
        this.platform = builder.platform;
        this.description = builder.description;
        this.stateChangeReason = builder.stateChangeReason;
        this.applications = builder.applications;
        this.createdTime = builder.createdTime;
        this.publicBaseImageReleasedDate = builder.publicBaseImageReleasedDate;
    }

    public String name() {
        return this.name;
    }

    public String arn() {
        return this.arn;
    }

    public String baseImageArn() {
        return this.baseImageArn;
    }

    public String displayName() {
        return this.displayName;
    }

    public ImageState state() {
        return ImageState.fromValue(this.state);
    }

    public String stateString() {
        return this.state;
    }

    public VisibilityType visibility() {
        return VisibilityType.fromValue(this.visibility);
    }

    public String visibilityString() {
        return this.visibility;
    }

    public Boolean imageBuilderSupported() {
        return this.imageBuilderSupported;
    }

    public PlatformType platform() {
        return PlatformType.fromValue(this.platform);
    }

    public String platformString() {
        return this.platform;
    }

    public String description() {
        return this.description;
    }

    public ImageStateChangeReason stateChangeReason() {
        return this.stateChangeReason;
    }

    public List<Application> applications() {
        return this.applications;
    }

    public Instant createdTime() {
        return this.createdTime;
    }

    public Instant publicBaseImageReleasedDate() {
        return this.publicBaseImageReleasedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseImageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateString());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityString());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageBuilderSupported());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateChangeReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.applications());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicBaseImageReleasedDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Image)) {
            return false;
        }
        Image other = (Image)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.baseImageArn(), other.baseImageArn()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.stateString(), other.stateString()) && Objects.equals(this.visibilityString(), other.visibilityString()) && Objects.equals(this.imageBuilderSupported(), other.imageBuilderSupported()) && Objects.equals(this.platformString(), other.platformString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.stateChangeReason(), other.stateChangeReason()) && Objects.equals(this.applications(), other.applications()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.publicBaseImageReleasedDate(), other.publicBaseImageReleasedDate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.baseImageArn() != null) {
            sb.append("BaseImageArn: ").append(this.baseImageArn()).append(",");
        }
        if (this.displayName() != null) {
            sb.append("DisplayName: ").append(this.displayName()).append(",");
        }
        if (this.stateString() != null) {
            sb.append("State: ").append(this.stateString()).append(",");
        }
        if (this.visibilityString() != null) {
            sb.append("Visibility: ").append(this.visibilityString()).append(",");
        }
        if (this.imageBuilderSupported() != null) {
            sb.append("ImageBuilderSupported: ").append(this.imageBuilderSupported()).append(",");
        }
        if (this.platformString() != null) {
            sb.append("Platform: ").append(this.platformString()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.stateChangeReason() != null) {
            sb.append("StateChangeReason: ").append(this.stateChangeReason()).append(",");
        }
        if (this.applications() != null) {
            sb.append("Applications: ").append(this.applications()).append(",");
        }
        if (this.createdTime() != null) {
            sb.append("CreatedTime: ").append(this.createdTime()).append(",");
        }
        if (this.publicBaseImageReleasedDate() != null) {
            sb.append("PublicBaseImageReleasedDate: ").append(this.publicBaseImageReleasedDate()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Arn": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "BaseImageArn": {
                return Optional.of(clazz.cast(this.baseImageArn()));
            }
            case "DisplayName": {
                return Optional.of(clazz.cast(this.displayName()));
            }
            case "State": {
                return Optional.of(clazz.cast(this.stateString()));
            }
            case "Visibility": {
                return Optional.of(clazz.cast(this.visibilityString()));
            }
            case "ImageBuilderSupported": {
                return Optional.of(clazz.cast(this.imageBuilderSupported()));
            }
            case "Platform": {
                return Optional.of(clazz.cast(this.platformString()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "StateChangeReason": {
                return Optional.of(clazz.cast(this.stateChangeReason()));
            }
            case "Applications": {
                return Optional.of(clazz.cast(this.applications()));
            }
            case "CreatedTime": {
                return Optional.of(clazz.cast(this.createdTime()));
            }
            case "PublicBaseImageReleasedDate": {
                return Optional.of(clazz.cast(this.publicBaseImageReleasedDate()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ImageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String baseImageArn;
        private String displayName;
        private String state;
        private String visibility;
        private Boolean imageBuilderSupported;
        private String platform;
        private String description;
        private ImageStateChangeReason stateChangeReason;
        private List<Application> applications;
        private Instant createdTime;
        private Instant publicBaseImageReleasedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(Image model) {
            this.name(model.name);
            this.arn(model.arn);
            this.baseImageArn(model.baseImageArn);
            this.displayName(model.displayName);
            this.state(model.state);
            this.visibility(model.visibility);
            this.imageBuilderSupported(model.imageBuilderSupported);
            this.platform(model.platform);
            this.description(model.description);
            this.stateChangeReason(model.stateChangeReason);
            this.applications(model.applications);
            this.createdTime(model.createdTime);
            this.publicBaseImageReleasedDate(model.publicBaseImageReleasedDate);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getBaseImageArn() {
            return this.baseImageArn;
        }

        @Override
        public final Builder baseImageArn(String baseImageArn) {
            this.baseImageArn = baseImageArn;
            return this;
        }

        public final void setBaseImageArn(String baseImageArn) {
            this.baseImageArn = baseImageArn;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ImageState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getVisibility() {
            return this.visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(VisibilityType visibility) {
            this.visibility(visibility.toString());
            return this;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        public final Boolean getImageBuilderSupported() {
            return this.imageBuilderSupported;
        }

        @Override
        public final Builder imageBuilderSupported(Boolean imageBuilderSupported) {
            this.imageBuilderSupported = imageBuilderSupported;
            return this;
        }

        public final void setImageBuilderSupported(Boolean imageBuilderSupported) {
            this.imageBuilderSupported = imageBuilderSupported;
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(PlatformType platform) {
            this.platform(platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final ImageStateChangeReason.Builder getStateChangeReason() {
            return this.stateChangeReason != null ? this.stateChangeReason.toBuilder() : null;
        }

        @Override
        public final Builder stateChangeReason(ImageStateChangeReason stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
            return this;
        }

        public final void setStateChangeReason(ImageStateChangeReason.BuilderImpl stateChangeReason) {
            this.stateChangeReason = stateChangeReason != null ? stateChangeReason.build() : null;
        }

        public final Collection<Application.Builder> getApplications() {
            return this.applications != null ? (Collection)this.applications.stream().map(Application::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder applications(Collection<Application> applications) {
            this.applications = ApplicationsCopier.copy(applications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applications(Application ... applications) {
            this.applications(Arrays.asList(applications));
            return this;
        }

        public final void setApplications(Collection<Application.BuilderImpl> applications) {
            this.applications = ApplicationsCopier.copyFromBuilder(applications);
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final Instant getPublicBaseImageReleasedDate() {
            return this.publicBaseImageReleasedDate;
        }

        @Override
        public final Builder publicBaseImageReleasedDate(Instant publicBaseImageReleasedDate) {
            this.publicBaseImageReleasedDate = publicBaseImageReleasedDate;
            return this;
        }

        public final void setPublicBaseImageReleasedDate(Instant publicBaseImageReleasedDate) {
            this.publicBaseImageReleasedDate = publicBaseImageReleasedDate;
        }

        public Image build() {
            return new Image(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Image> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder baseImageArn(String var1);

        public Builder displayName(String var1);

        public Builder state(String var1);

        public Builder state(ImageState var1);

        public Builder visibility(String var1);

        public Builder visibility(VisibilityType var1);

        public Builder imageBuilderSupported(Boolean var1);

        public Builder platform(String var1);

        public Builder platform(PlatformType var1);

        public Builder description(String var1);

        public Builder stateChangeReason(ImageStateChangeReason var1);

        default public Builder stateChangeReason(Consumer<ImageStateChangeReason.Builder> stateChangeReason) {
            return this.stateChangeReason((ImageStateChangeReason)((ImageStateChangeReason.Builder)ImageStateChangeReason.builder().apply(stateChangeReason)).build());
        }

        public Builder applications(Collection<Application> var1);

        public Builder applications(Application ... var1);

        public Builder createdTime(Instant var1);

        public Builder publicBaseImageReleasedDate(Instant var1);
    }
}

