/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.waiters;

import com.fasterxml.jackson.databind.JsonNode;
import io.burt.jmespath.Expression;
import io.burt.jmespath.jackson.JacksonRuntime;
import java.io.IOException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.services.appstream.model.DescribeFleetsResponse;
import software.amazon.awssdk.waiters.AcceptorPathMatcher;
import software.amazon.awssdk.waiters.ObjectMapperSingleton;
import software.amazon.awssdk.waiters.WaiterAcceptor;
import software.amazon.awssdk.waiters.WaiterState;

@SdkInternalApi
class FleetStopped {
    FleetStopped() {
    }

    static class IsACTIVEMatcher
    extends WaiterAcceptor<DescribeFleetsResponse> {
        private static final JsonNode EXPECTED_RESULT;
        private static final Expression<JsonNode> AST;

        IsACTIVEMatcher() {
        }

        public boolean matches(DescribeFleetsResponse result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = (JsonNode)AST.search((Object)queryNode);
            return AcceptorPathMatcher.pathAny((JsonNode)EXPECTED_RESULT, (JsonNode)finalResult);
        }

        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                EXPECTED_RESULT = ObjectMapperSingleton.getObjectMapper().readTree("\"ACTIVE\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            AST = new JacksonRuntime().compile("fleets[].state");
        }
    }

    static class IsPENDING_ACTIVATEMatcher
    extends WaiterAcceptor<DescribeFleetsResponse> {
        private static final JsonNode EXPECTED_RESULT;
        private static final Expression<JsonNode> AST;

        IsPENDING_ACTIVATEMatcher() {
        }

        public boolean matches(DescribeFleetsResponse result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = (JsonNode)AST.search((Object)queryNode);
            return AcceptorPathMatcher.pathAny((JsonNode)EXPECTED_RESULT, (JsonNode)finalResult);
        }

        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                EXPECTED_RESULT = ObjectMapperSingleton.getObjectMapper().readTree("\"PENDING_ACTIVATE\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            AST = new JacksonRuntime().compile("fleets[].state");
        }
    }

    static class IsINACTIVEMatcher
    extends WaiterAcceptor<DescribeFleetsResponse> {
        private static final JsonNode EXPECTED_RESULT;
        private static final Expression<JsonNode> AST;

        IsINACTIVEMatcher() {
        }

        public boolean matches(DescribeFleetsResponse result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = (JsonNode)AST.search((Object)queryNode);
            return AcceptorPathMatcher.pathAll((JsonNode)EXPECTED_RESULT, (JsonNode)finalResult);
        }

        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }

        static {
            try {
                EXPECTED_RESULT = ObjectMapperSingleton.getObjectMapper().readTree("\"INACTIVE\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            AST = new JacksonRuntime().compile("fleets[].state");
        }
    }
}

