/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.appstream.model.Fleet;
import software.amazon.awssdk.services.appstream.transform.ComputeCapacityStatusUnmarshaller;
import software.amazon.awssdk.services.appstream.transform.FleetErrorUnmarshaller;
import software.amazon.awssdk.services.appstream.transform.VpcConfigUnmarshaller;

public class FleetUnmarshaller
implements Unmarshaller<Fleet, JsonUnmarshallerContext> {
    private static FleetUnmarshaller INSTANCE;

    public Fleet unmarshall(JsonUnmarshallerContext context) throws Exception {
        Fleet.Builder fleetBuilder = Fleet.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Arn", targetDepth)) {
                    context.nextToken();
                    fleetBuilder.arn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    fleetBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DisplayName", targetDepth)) {
                    context.nextToken();
                    fleetBuilder.displayName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    fleetBuilder.description((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ImageName", targetDepth)) {
                    context.nextToken();
                    fleetBuilder.imageName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("InstanceType", targetDepth)) {
                    context.nextToken();
                    fleetBuilder.instanceType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ComputeCapacityStatus", targetDepth)) {
                    context.nextToken();
                    fleetBuilder.computeCapacityStatus(ComputeCapacityStatusUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("MaxUserDurationInSeconds", targetDepth)) {
                    context.nextToken();
                    fleetBuilder.maxUserDurationInSeconds((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("DisconnectTimeoutInSeconds", targetDepth)) {
                    context.nextToken();
                    fleetBuilder.disconnectTimeoutInSeconds((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("State", targetDepth)) {
                    context.nextToken();
                    fleetBuilder.state((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("VpcConfig", targetDepth)) {
                    context.nextToken();
                    fleetBuilder.vpcConfig(VpcConfigUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("CreatedTime", targetDepth)) {
                    context.nextToken();
                    fleetBuilder.createdTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("FleetErrors", targetDepth)) {
                    context.nextToken();
                    fleetBuilder.fleetErrors(new ListUnmarshaller((Unmarshaller)FleetErrorUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("EnableDefaultInternetAccess", targetDepth)) {
                    context.nextToken();
                    fleetBuilder.enableDefaultInternetAccess((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Fleet)fleetBuilder.build();
    }

    public static FleetUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FleetUnmarshaller();
        }
        return INSTANCE;
    }
}

