/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.appstream.model.CopyImageRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CopyImageRequestModelMarshaller {
    private static final MarshallingInfo<String> SOURCEIMAGENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceImageName").isBinary(false).build();
    private static final MarshallingInfo<String> DESTINATIONIMAGENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DestinationImageName").isBinary(false).build();
    private static final MarshallingInfo<String> DESTINATIONREGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DestinationRegion").isBinary(false).build();
    private static final MarshallingInfo<String> DESTINATIONIMAGEDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DestinationImageDescription").isBinary(false).build();
    private static final CopyImageRequestModelMarshaller INSTANCE = new CopyImageRequestModelMarshaller();

    private CopyImageRequestModelMarshaller() {
    }

    public static CopyImageRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CopyImageRequest copyImageRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)copyImageRequest), (String)"copyImageRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)copyImageRequest.sourceImageName(), SOURCEIMAGENAME_BINDING);
            protocolMarshaller.marshall((Object)copyImageRequest.destinationImageName(), DESTINATIONIMAGENAME_BINDING);
            protocolMarshaller.marshall((Object)copyImageRequest.destinationRegion(), DESTINATIONREGION_BINDING);
            protocolMarshaller.marshall((Object)copyImageRequest.destinationImageDescription(), DESTINATIONIMAGEDESCRIPTION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

