/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.appstream.model.AppStreamRequest;
import software.amazon.awssdk.services.appstream.model.ApplicationSettings;
import software.amazon.awssdk.services.appstream.model.StackAttribute;
import software.amazon.awssdk.services.appstream.model.StackAttributesCopier;
import software.amazon.awssdk.services.appstream.model.StorageConnector;
import software.amazon.awssdk.services.appstream.model.StorageConnectorListCopier;
import software.amazon.awssdk.services.appstream.model.UserSetting;
import software.amazon.awssdk.services.appstream.model.UserSettingListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateStackRequest
extends AppStreamRequest
implements ToCopyableBuilder<Builder, UpdateStackRequest> {
    private final String displayName;
    private final String description;
    private final String name;
    private final List<StorageConnector> storageConnectors;
    private final Boolean deleteStorageConnectors;
    private final String redirectURL;
    private final String feedbackURL;
    private final List<String> attributesToDelete;
    private final List<UserSetting> userSettings;
    private final ApplicationSettings applicationSettings;

    private UpdateStackRequest(BuilderImpl builder) {
        super(builder);
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.name = builder.name;
        this.storageConnectors = builder.storageConnectors;
        this.deleteStorageConnectors = builder.deleteStorageConnectors;
        this.redirectURL = builder.redirectURL;
        this.feedbackURL = builder.feedbackURL;
        this.attributesToDelete = builder.attributesToDelete;
        this.userSettings = builder.userSettings;
        this.applicationSettings = builder.applicationSettings;
    }

    public String displayName() {
        return this.displayName;
    }

    public String description() {
        return this.description;
    }

    public String name() {
        return this.name;
    }

    public List<StorageConnector> storageConnectors() {
        return this.storageConnectors;
    }

    public Boolean deleteStorageConnectors() {
        return this.deleteStorageConnectors;
    }

    public String redirectURL() {
        return this.redirectURL;
    }

    public String feedbackURL() {
        return this.feedbackURL;
    }

    public List<StackAttribute> attributesToDelete() {
        return TypeConverter.convert(this.attributesToDelete, StackAttribute::fromValue);
    }

    public List<String> attributesToDeleteAsStrings() {
        return this.attributesToDelete;
    }

    public List<UserSetting> userSettings() {
        return this.userSettings;
    }

    public ApplicationSettings applicationSettings() {
        return this.applicationSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageConnectors());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteStorageConnectors());
        hashCode = 31 * hashCode + Objects.hashCode(this.redirectURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.feedbackURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributesToDeleteAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.userSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationSettings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStackRequest)) {
            return false;
        }
        UpdateStackRequest other = (UpdateStackRequest)((Object)obj);
        return Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.storageConnectors(), other.storageConnectors()) && Objects.equals(this.deleteStorageConnectors(), other.deleteStorageConnectors()) && Objects.equals(this.redirectURL(), other.redirectURL()) && Objects.equals(this.feedbackURL(), other.feedbackURL()) && Objects.equals(this.attributesToDeleteAsStrings(), other.attributesToDeleteAsStrings()) && Objects.equals(this.userSettings(), other.userSettings()) && Objects.equals(this.applicationSettings(), other.applicationSettings());
    }

    public String toString() {
        return ToString.builder((String)"UpdateStackRequest").add("DisplayName", (Object)this.displayName()).add("Description", (Object)this.description()).add("Name", (Object)this.name()).add("StorageConnectors", this.storageConnectors()).add("DeleteStorageConnectors", (Object)this.deleteStorageConnectors()).add("RedirectURL", (Object)this.redirectURL()).add("FeedbackURL", (Object)this.feedbackURL()).add("AttributesToDelete", this.attributesToDeleteAsStrings()).add("UserSettings", this.userSettings()).add("ApplicationSettings", (Object)this.applicationSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "StorageConnectors": {
                return Optional.ofNullable(clazz.cast(this.storageConnectors()));
            }
            case "DeleteStorageConnectors": {
                return Optional.ofNullable(clazz.cast(this.deleteStorageConnectors()));
            }
            case "RedirectURL": {
                return Optional.ofNullable(clazz.cast(this.redirectURL()));
            }
            case "FeedbackURL": {
                return Optional.ofNullable(clazz.cast(this.feedbackURL()));
            }
            case "AttributesToDelete": {
                return Optional.ofNullable(clazz.cast(this.attributesToDeleteAsStrings()));
            }
            case "UserSettings": {
                return Optional.ofNullable(clazz.cast(this.userSettings()));
            }
            case "ApplicationSettings": {
                return Optional.ofNullable(clazz.cast(this.applicationSettings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AppStreamRequest.BuilderImpl
    implements Builder {
        private String displayName;
        private String description;
        private String name;
        private List<StorageConnector> storageConnectors = DefaultSdkAutoConstructList.getInstance();
        private Boolean deleteStorageConnectors;
        private String redirectURL;
        private String feedbackURL;
        private List<String> attributesToDelete = DefaultSdkAutoConstructList.getInstance();
        private List<UserSetting> userSettings = DefaultSdkAutoConstructList.getInstance();
        private ApplicationSettings applicationSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStackRequest model) {
            super(model);
            this.displayName(model.displayName);
            this.description(model.description);
            this.name(model.name);
            this.storageConnectors(model.storageConnectors);
            this.deleteStorageConnectors(model.deleteStorageConnectors);
            this.redirectURL(model.redirectURL);
            this.feedbackURL(model.feedbackURL);
            this.attributesToDeleteWithStrings(model.attributesToDelete);
            this.userSettings(model.userSettings);
            this.applicationSettings(model.applicationSettings);
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<StorageConnector.Builder> getStorageConnectors() {
            return this.storageConnectors != null ? (Collection)this.storageConnectors.stream().map(StorageConnector::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder storageConnectors(Collection<StorageConnector> storageConnectors) {
            this.storageConnectors = StorageConnectorListCopier.copy(storageConnectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConnectors(StorageConnector ... storageConnectors) {
            this.storageConnectors(Arrays.asList(storageConnectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConnectors(Consumer<StorageConnector.Builder> ... storageConnectors) {
            this.storageConnectors(Stream.of(storageConnectors).map(c -> (StorageConnector)((StorageConnector.Builder)StorageConnector.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStorageConnectors(Collection<StorageConnector.BuilderImpl> storageConnectors) {
            this.storageConnectors = StorageConnectorListCopier.copyFromBuilder(storageConnectors);
        }

        public final Boolean getDeleteStorageConnectors() {
            return this.deleteStorageConnectors;
        }

        @Override
        public final Builder deleteStorageConnectors(Boolean deleteStorageConnectors) {
            this.deleteStorageConnectors = deleteStorageConnectors;
            return this;
        }

        public final void setDeleteStorageConnectors(Boolean deleteStorageConnectors) {
            this.deleteStorageConnectors = deleteStorageConnectors;
        }

        public final String getRedirectURL() {
            return this.redirectURL;
        }

        @Override
        public final Builder redirectURL(String redirectURL) {
            this.redirectURL = redirectURL;
            return this;
        }

        public final void setRedirectURL(String redirectURL) {
            this.redirectURL = redirectURL;
        }

        public final String getFeedbackURL() {
            return this.feedbackURL;
        }

        @Override
        public final Builder feedbackURL(String feedbackURL) {
            this.feedbackURL = feedbackURL;
            return this;
        }

        public final void setFeedbackURL(String feedbackURL) {
            this.feedbackURL = feedbackURL;
        }

        public final Collection<String> getAttributesToDelete() {
            return this.attributesToDelete;
        }

        @Override
        public final Builder attributesToDeleteWithStrings(Collection<String> attributesToDelete) {
            this.attributesToDelete = StackAttributesCopier.copy(attributesToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesToDeleteWithStrings(String ... attributesToDelete) {
            this.attributesToDeleteWithStrings(Arrays.asList(attributesToDelete));
            return this;
        }

        @Override
        public final Builder attributesToDelete(Collection<StackAttribute> attributesToDelete) {
            this.attributesToDelete = StackAttributesCopier.copyEnumToString(attributesToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesToDelete(StackAttribute ... attributesToDelete) {
            this.attributesToDelete(Arrays.asList(attributesToDelete));
            return this;
        }

        public final void setAttributesToDelete(Collection<String> attributesToDelete) {
            this.attributesToDelete = StackAttributesCopier.copy(attributesToDelete);
        }

        public final Collection<UserSetting.Builder> getUserSettings() {
            return this.userSettings != null ? (Collection)this.userSettings.stream().map(UserSetting::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder userSettings(Collection<UserSetting> userSettings) {
            this.userSettings = UserSettingListCopier.copy(userSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userSettings(UserSetting ... userSettings) {
            this.userSettings(Arrays.asList(userSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userSettings(Consumer<UserSetting.Builder> ... userSettings) {
            this.userSettings(Stream.of(userSettings).map(c -> (UserSetting)((UserSetting.Builder)UserSetting.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUserSettings(Collection<UserSetting.BuilderImpl> userSettings) {
            this.userSettings = UserSettingListCopier.copyFromBuilder(userSettings);
        }

        public final ApplicationSettings.Builder getApplicationSettings() {
            return this.applicationSettings != null ? this.applicationSettings.toBuilder() : null;
        }

        @Override
        public final Builder applicationSettings(ApplicationSettings applicationSettings) {
            this.applicationSettings = applicationSettings;
            return this;
        }

        public final void setApplicationSettings(ApplicationSettings.BuilderImpl applicationSettings) {
            this.applicationSettings = applicationSettings != null ? applicationSettings.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStackRequest build() {
            return new UpdateStackRequest(this);
        }
    }

    public static interface Builder
    extends AppStreamRequest.Builder,
    CopyableBuilder<Builder, UpdateStackRequest> {
        public Builder displayName(String var1);

        public Builder description(String var1);

        public Builder name(String var1);

        public Builder storageConnectors(Collection<StorageConnector> var1);

        public Builder storageConnectors(StorageConnector ... var1);

        public Builder storageConnectors(Consumer<StorageConnector.Builder> ... var1);

        public Builder deleteStorageConnectors(Boolean var1);

        public Builder redirectURL(String var1);

        public Builder feedbackURL(String var1);

        public Builder attributesToDeleteWithStrings(Collection<String> var1);

        public Builder attributesToDeleteWithStrings(String ... var1);

        public Builder attributesToDelete(Collection<StackAttribute> var1);

        public Builder attributesToDelete(StackAttribute ... var1);

        public Builder userSettings(Collection<UserSetting> var1);

        public Builder userSettings(UserSetting ... var1);

        public Builder userSettings(Consumer<UserSetting.Builder> ... var1);

        public Builder applicationSettings(ApplicationSettings var1);

        default public Builder applicationSettings(Consumer<ApplicationSettings.Builder> applicationSettings) {
            return this.applicationSettings((ApplicationSettings)((ApplicationSettings.Builder)ApplicationSettings.builder().applyMutation(applicationSettings)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

