/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.appstream.model.AppStreamRequest;
import software.amazon.awssdk.services.appstream.model.ComputeCapacity;
import software.amazon.awssdk.services.appstream.model.DomainJoinInfo;
import software.amazon.awssdk.services.appstream.model.FleetAttribute;
import software.amazon.awssdk.services.appstream.model.FleetAttributesCopier;
import software.amazon.awssdk.services.appstream.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFleetRequest
extends AppStreamRequest
implements ToCopyableBuilder<Builder, UpdateFleetRequest> {
    private final String imageName;
    private final String imageArn;
    private final String name;
    private final String instanceType;
    private final ComputeCapacity computeCapacity;
    private final VpcConfig vpcConfig;
    private final Integer maxUserDurationInSeconds;
    private final Integer disconnectTimeoutInSeconds;
    private final Boolean deleteVpcConfig;
    private final String description;
    private final String displayName;
    private final Boolean enableDefaultInternetAccess;
    private final DomainJoinInfo domainJoinInfo;
    private final List<String> attributesToDelete;

    private UpdateFleetRequest(BuilderImpl builder) {
        super(builder);
        this.imageName = builder.imageName;
        this.imageArn = builder.imageArn;
        this.name = builder.name;
        this.instanceType = builder.instanceType;
        this.computeCapacity = builder.computeCapacity;
        this.vpcConfig = builder.vpcConfig;
        this.maxUserDurationInSeconds = builder.maxUserDurationInSeconds;
        this.disconnectTimeoutInSeconds = builder.disconnectTimeoutInSeconds;
        this.deleteVpcConfig = builder.deleteVpcConfig;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.enableDefaultInternetAccess = builder.enableDefaultInternetAccess;
        this.domainJoinInfo = builder.domainJoinInfo;
        this.attributesToDelete = builder.attributesToDelete;
    }

    public String imageName() {
        return this.imageName;
    }

    public String imageArn() {
        return this.imageArn;
    }

    public String name() {
        return this.name;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public ComputeCapacity computeCapacity() {
        return this.computeCapacity;
    }

    public VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public Integer maxUserDurationInSeconds() {
        return this.maxUserDurationInSeconds;
    }

    public Integer disconnectTimeoutInSeconds() {
        return this.disconnectTimeoutInSeconds;
    }

    public Boolean deleteVpcConfig() {
        return this.deleteVpcConfig;
    }

    public String description() {
        return this.description;
    }

    public String displayName() {
        return this.displayName;
    }

    public Boolean enableDefaultInternetAccess() {
        return this.enableDefaultInternetAccess;
    }

    public DomainJoinInfo domainJoinInfo() {
        return this.domainJoinInfo;
    }

    public List<FleetAttribute> attributesToDelete() {
        return TypeConverter.convert(this.attributesToDelete, FleetAttribute::fromValue);
    }

    public List<String> attributesToDeleteAsStrings() {
        return this.attributesToDelete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.imageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxUserDurationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.disconnectTimeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteVpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableDefaultInternetAccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainJoinInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributesToDeleteAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFleetRequest)) {
            return false;
        }
        UpdateFleetRequest other = (UpdateFleetRequest)((Object)obj);
        return Objects.equals(this.imageName(), other.imageName()) && Objects.equals(this.imageArn(), other.imageArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.computeCapacity(), other.computeCapacity()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.maxUserDurationInSeconds(), other.maxUserDurationInSeconds()) && Objects.equals(this.disconnectTimeoutInSeconds(), other.disconnectTimeoutInSeconds()) && Objects.equals(this.deleteVpcConfig(), other.deleteVpcConfig()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.enableDefaultInternetAccess(), other.enableDefaultInternetAccess()) && Objects.equals(this.domainJoinInfo(), other.domainJoinInfo()) && Objects.equals(this.attributesToDeleteAsStrings(), other.attributesToDeleteAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"UpdateFleetRequest").add("ImageName", (Object)this.imageName()).add("ImageArn", (Object)this.imageArn()).add("Name", (Object)this.name()).add("InstanceType", (Object)this.instanceType()).add("ComputeCapacity", (Object)this.computeCapacity()).add("VpcConfig", (Object)this.vpcConfig()).add("MaxUserDurationInSeconds", (Object)this.maxUserDurationInSeconds()).add("DisconnectTimeoutInSeconds", (Object)this.disconnectTimeoutInSeconds()).add("DeleteVpcConfig", (Object)this.deleteVpcConfig()).add("Description", (Object)this.description()).add("DisplayName", (Object)this.displayName()).add("EnableDefaultInternetAccess", (Object)this.enableDefaultInternetAccess()).add("DomainJoinInfo", (Object)this.domainJoinInfo()).add("AttributesToDelete", this.attributesToDeleteAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImageName": {
                return Optional.ofNullable(clazz.cast(this.imageName()));
            }
            case "ImageArn": {
                return Optional.ofNullable(clazz.cast(this.imageArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "ComputeCapacity": {
                return Optional.ofNullable(clazz.cast(this.computeCapacity()));
            }
            case "VpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "MaxUserDurationInSeconds": {
                return Optional.ofNullable(clazz.cast(this.maxUserDurationInSeconds()));
            }
            case "DisconnectTimeoutInSeconds": {
                return Optional.ofNullable(clazz.cast(this.disconnectTimeoutInSeconds()));
            }
            case "DeleteVpcConfig": {
                return Optional.ofNullable(clazz.cast(this.deleteVpcConfig()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "EnableDefaultInternetAccess": {
                return Optional.ofNullable(clazz.cast(this.enableDefaultInternetAccess()));
            }
            case "DomainJoinInfo": {
                return Optional.ofNullable(clazz.cast(this.domainJoinInfo()));
            }
            case "AttributesToDelete": {
                return Optional.ofNullable(clazz.cast(this.attributesToDeleteAsStrings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AppStreamRequest.BuilderImpl
    implements Builder {
        private String imageName;
        private String imageArn;
        private String name;
        private String instanceType;
        private ComputeCapacity computeCapacity;
        private VpcConfig vpcConfig;
        private Integer maxUserDurationInSeconds;
        private Integer disconnectTimeoutInSeconds;
        private Boolean deleteVpcConfig;
        private String description;
        private String displayName;
        private Boolean enableDefaultInternetAccess;
        private DomainJoinInfo domainJoinInfo;
        private List<String> attributesToDelete = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFleetRequest model) {
            super(model);
            this.imageName(model.imageName);
            this.imageArn(model.imageArn);
            this.name(model.name);
            this.instanceType(model.instanceType);
            this.computeCapacity(model.computeCapacity);
            this.vpcConfig(model.vpcConfig);
            this.maxUserDurationInSeconds(model.maxUserDurationInSeconds);
            this.disconnectTimeoutInSeconds(model.disconnectTimeoutInSeconds);
            this.deleteVpcConfig(model.deleteVpcConfig);
            this.description(model.description);
            this.displayName(model.displayName);
            this.enableDefaultInternetAccess(model.enableDefaultInternetAccess);
            this.domainJoinInfo(model.domainJoinInfo);
            this.attributesToDeleteWithStrings(model.attributesToDelete);
        }

        public final String getImageName() {
            return this.imageName;
        }

        @Override
        public final Builder imageName(String imageName) {
            this.imageName = imageName;
            return this;
        }

        public final void setImageName(String imageName) {
            this.imageName = imageName;
        }

        public final String getImageArn() {
            return this.imageArn;
        }

        @Override
        public final Builder imageArn(String imageArn) {
            this.imageArn = imageArn;
            return this;
        }

        public final void setImageArn(String imageArn) {
            this.imageArn = imageArn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final ComputeCapacity.Builder getComputeCapacity() {
            return this.computeCapacity != null ? this.computeCapacity.toBuilder() : null;
        }

        @Override
        public final Builder computeCapacity(ComputeCapacity computeCapacity) {
            this.computeCapacity = computeCapacity;
            return this;
        }

        public final void setComputeCapacity(ComputeCapacity.BuilderImpl computeCapacity) {
            this.computeCapacity = computeCapacity != null ? computeCapacity.build() : null;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        public final Integer getMaxUserDurationInSeconds() {
            return this.maxUserDurationInSeconds;
        }

        @Override
        public final Builder maxUserDurationInSeconds(Integer maxUserDurationInSeconds) {
            this.maxUserDurationInSeconds = maxUserDurationInSeconds;
            return this;
        }

        public final void setMaxUserDurationInSeconds(Integer maxUserDurationInSeconds) {
            this.maxUserDurationInSeconds = maxUserDurationInSeconds;
        }

        public final Integer getDisconnectTimeoutInSeconds() {
            return this.disconnectTimeoutInSeconds;
        }

        @Override
        public final Builder disconnectTimeoutInSeconds(Integer disconnectTimeoutInSeconds) {
            this.disconnectTimeoutInSeconds = disconnectTimeoutInSeconds;
            return this;
        }

        public final void setDisconnectTimeoutInSeconds(Integer disconnectTimeoutInSeconds) {
            this.disconnectTimeoutInSeconds = disconnectTimeoutInSeconds;
        }

        public final Boolean getDeleteVpcConfig() {
            return this.deleteVpcConfig;
        }

        @Override
        public final Builder deleteVpcConfig(Boolean deleteVpcConfig) {
            this.deleteVpcConfig = deleteVpcConfig;
            return this;
        }

        public final void setDeleteVpcConfig(Boolean deleteVpcConfig) {
            this.deleteVpcConfig = deleteVpcConfig;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final Boolean getEnableDefaultInternetAccess() {
            return this.enableDefaultInternetAccess;
        }

        @Override
        public final Builder enableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
            return this;
        }

        public final void setEnableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
        }

        public final DomainJoinInfo.Builder getDomainJoinInfo() {
            return this.domainJoinInfo != null ? this.domainJoinInfo.toBuilder() : null;
        }

        @Override
        public final Builder domainJoinInfo(DomainJoinInfo domainJoinInfo) {
            this.domainJoinInfo = domainJoinInfo;
            return this;
        }

        public final void setDomainJoinInfo(DomainJoinInfo.BuilderImpl domainJoinInfo) {
            this.domainJoinInfo = domainJoinInfo != null ? domainJoinInfo.build() : null;
        }

        public final Collection<String> getAttributesToDelete() {
            return this.attributesToDelete;
        }

        @Override
        public final Builder attributesToDeleteWithStrings(Collection<String> attributesToDelete) {
            this.attributesToDelete = FleetAttributesCopier.copy(attributesToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesToDeleteWithStrings(String ... attributesToDelete) {
            this.attributesToDeleteWithStrings(Arrays.asList(attributesToDelete));
            return this;
        }

        @Override
        public final Builder attributesToDelete(Collection<FleetAttribute> attributesToDelete) {
            this.attributesToDelete = FleetAttributesCopier.copyEnumToString(attributesToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesToDelete(FleetAttribute ... attributesToDelete) {
            this.attributesToDelete(Arrays.asList(attributesToDelete));
            return this;
        }

        public final void setAttributesToDelete(Collection<String> attributesToDelete) {
            this.attributesToDelete = FleetAttributesCopier.copy(attributesToDelete);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFleetRequest build() {
            return new UpdateFleetRequest(this);
        }
    }

    public static interface Builder
    extends AppStreamRequest.Builder,
    CopyableBuilder<Builder, UpdateFleetRequest> {
        public Builder imageName(String var1);

        public Builder imageArn(String var1);

        public Builder name(String var1);

        public Builder instanceType(String var1);

        public Builder computeCapacity(ComputeCapacity var1);

        default public Builder computeCapacity(Consumer<ComputeCapacity.Builder> computeCapacity) {
            return this.computeCapacity((ComputeCapacity)((ComputeCapacity.Builder)ComputeCapacity.builder().applyMutation(computeCapacity)).build());
        }

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder maxUserDurationInSeconds(Integer var1);

        public Builder disconnectTimeoutInSeconds(Integer var1);

        public Builder deleteVpcConfig(Boolean var1);

        public Builder description(String var1);

        public Builder displayName(String var1);

        public Builder enableDefaultInternetAccess(Boolean var1);

        public Builder domainJoinInfo(DomainJoinInfo var1);

        default public Builder domainJoinInfo(Consumer<DomainJoinInfo.Builder> domainJoinInfo) {
            return this.domainJoinInfo((DomainJoinInfo)((DomainJoinInfo.Builder)DomainJoinInfo.builder().applyMutation(domainJoinInfo)).build());
        }

        public Builder attributesToDeleteWithStrings(Collection<String> var1);

        public Builder attributesToDeleteWithStrings(String ... var1);

        public Builder attributesToDelete(Collection<FleetAttribute> var1);

        public Builder attributesToDelete(FleetAttribute ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

