/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.appstream.model.MetadataCopier;
import software.amazon.awssdk.services.appstream.transform.ApplicationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Application
implements StructuredPojo,
ToCopyableBuilder<Builder, Application> {
    private final String name;
    private final String displayName;
    private final String iconURL;
    private final String launchPath;
    private final String launchParameters;
    private final Boolean enabled;
    private final Map<String, String> metadata;

    private Application(BuilderImpl builder) {
        this.name = builder.name;
        this.displayName = builder.displayName;
        this.iconURL = builder.iconURL;
        this.launchPath = builder.launchPath;
        this.launchParameters = builder.launchParameters;
        this.enabled = builder.enabled;
        this.metadata = builder.metadata;
    }

    public String name() {
        return this.name;
    }

    public String displayName() {
        return this.displayName;
    }

    public String iconURL() {
        return this.iconURL;
    }

    public String launchPath() {
        return this.launchPath;
    }

    public String launchParameters() {
        return this.launchParameters;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public Map<String, String> metadata() {
        return this.metadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.iconURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Application)) {
            return false;
        }
        Application other = (Application)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.iconURL(), other.iconURL()) && Objects.equals(this.launchPath(), other.launchPath()) && Objects.equals(this.launchParameters(), other.launchParameters()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.metadata(), other.metadata());
    }

    public String toString() {
        return ToString.builder((String)"Application").add("Name", (Object)this.name()).add("DisplayName", (Object)this.displayName()).add("IconURL", (Object)this.iconURL()).add("LaunchPath", (Object)this.launchPath()).add("LaunchParameters", (Object)this.launchParameters()).add("Enabled", (Object)this.enabled()).add("Metadata", this.metadata()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "IconURL": {
                return Optional.ofNullable(clazz.cast(this.iconURL()));
            }
            case "LaunchPath": {
                return Optional.ofNullable(clazz.cast(this.launchPath()));
            }
            case "LaunchParameters": {
                return Optional.ofNullable(clazz.cast(this.launchParameters()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "Metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ApplicationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String displayName;
        private String iconURL;
        private String launchPath;
        private String launchParameters;
        private Boolean enabled;
        private Map<String, String> metadata = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Application model) {
            this.name(model.name);
            this.displayName(model.displayName);
            this.iconURL(model.iconURL);
            this.launchPath(model.launchPath);
            this.launchParameters(model.launchParameters);
            this.enabled(model.enabled);
            this.metadata(model.metadata);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getIconURL() {
            return this.iconURL;
        }

        @Override
        public final Builder iconURL(String iconURL) {
            this.iconURL = iconURL;
            return this;
        }

        public final void setIconURL(String iconURL) {
            this.iconURL = iconURL;
        }

        public final String getLaunchPath() {
            return this.launchPath;
        }

        @Override
        public final Builder launchPath(String launchPath) {
            this.launchPath = launchPath;
            return this;
        }

        public final void setLaunchPath(String launchPath) {
            this.launchPath = launchPath;
        }

        public final String getLaunchParameters() {
            return this.launchParameters;
        }

        @Override
        public final Builder launchParameters(String launchParameters) {
            this.launchParameters = launchParameters;
            return this;
        }

        public final void setLaunchParameters(String launchParameters) {
            this.launchParameters = launchParameters;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Map<String, String> getMetadata() {
            return this.metadata;
        }

        @Override
        public final Builder metadata(Map<String, String> metadata) {
            this.metadata = MetadataCopier.copy(metadata);
            return this;
        }

        public final void setMetadata(Map<String, String> metadata) {
            this.metadata = MetadataCopier.copy(metadata);
        }

        public Application build() {
            return new Application(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Application> {
        public Builder name(String var1);

        public Builder displayName(String var1);

        public Builder iconURL(String var1);

        public Builder launchPath(String var1);

        public Builder launchParameters(String var1);

        public Builder enabled(Boolean var1);

        public Builder metadata(Map<String, String> var1);
    }
}

