/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.model.AuthenticationType;
import software.amazon.awssdk.services.appstream.model.SessionState;
import software.amazon.awssdk.services.appstream.transform.SessionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Session
implements StructuredPojo,
ToCopyableBuilder<Builder, Session> {
    private final String id;
    private final String userId;
    private final String stackName;
    private final String fleetName;
    private final String state;
    private final String authenticationType;

    private Session(BuilderImpl builder) {
        this.id = builder.id;
        this.userId = builder.userId;
        this.stackName = builder.stackName;
        this.fleetName = builder.fleetName;
        this.state = builder.state;
        this.authenticationType = builder.authenticationType;
    }

    public String id() {
        return this.id;
    }

    public String userId() {
        return this.userId;
    }

    public String stackName() {
        return this.stackName;
    }

    public String fleetName() {
        return this.fleetName;
    }

    public SessionState state() {
        return SessionState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public AuthenticationType authenticationType() {
        return AuthenticationType.fromValue(this.authenticationType);
    }

    public String authenticationTypeAsString() {
        return this.authenticationType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Session)) {
            return false;
        }
        Session other = (Session)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.stackName(), other.stackName()) && Objects.equals(this.fleetName(), other.fleetName()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.authenticationTypeAsString(), other.authenticationTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"Session").add("Id", (Object)this.id()).add("UserId", (Object)this.userId()).add("StackName", (Object)this.stackName()).add("FleetName", (Object)this.fleetName()).add("State", (Object)this.stateAsString()).add("AuthenticationType", (Object)this.authenticationTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "StackName": {
                return Optional.ofNullable(clazz.cast(this.stackName()));
            }
            case "FleetName": {
                return Optional.ofNullable(clazz.cast(this.fleetName()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "AuthenticationType": {
                return Optional.ofNullable(clazz.cast(this.authenticationTypeAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SessionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String userId;
        private String stackName;
        private String fleetName;
        private String state;
        private String authenticationType;

        private BuilderImpl() {
        }

        private BuilderImpl(Session model) {
            this.id(model.id);
            this.userId(model.userId);
            this.stackName(model.stackName);
            this.fleetName(model.fleetName);
            this.state(model.state);
            this.authenticationType(model.authenticationType);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getUserId() {
            return this.userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getStackName() {
            return this.stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getFleetName() {
            return this.fleetName;
        }

        @Override
        public final Builder fleetName(String fleetName) {
            this.fleetName = fleetName;
            return this;
        }

        public final void setFleetName(String fleetName) {
            this.fleetName = fleetName;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SessionState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getAuthenticationType() {
            return this.authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType.toString());
            return this;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        public Session build() {
            return new Session(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Session> {
        public Builder id(String var1);

        public Builder userId(String var1);

        public Builder stackName(String var1);

        public Builder fleetName(String var1);

        public Builder state(String var1);

        public Builder state(SessionState var1);

        public Builder authenticationType(String var1);

        public Builder authenticationType(AuthenticationType var1);
    }
}

