/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.appstream.model.AppStreamRequest;
import software.amazon.awssdk.services.appstream.model.OrganizationalUnitDistinguishedNamesListCopier;
import software.amazon.awssdk.services.appstream.model.ServiceAccountCredentials;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateDirectoryConfigRequest
extends AppStreamRequest
implements ToCopyableBuilder<Builder, UpdateDirectoryConfigRequest> {
    private final String directoryName;
    private final List<String> organizationalUnitDistinguishedNames;
    private final ServiceAccountCredentials serviceAccountCredentials;

    private UpdateDirectoryConfigRequest(BuilderImpl builder) {
        super(builder);
        this.directoryName = builder.directoryName;
        this.organizationalUnitDistinguishedNames = builder.organizationalUnitDistinguishedNames;
        this.serviceAccountCredentials = builder.serviceAccountCredentials;
    }

    public String directoryName() {
        return this.directoryName;
    }

    public List<String> organizationalUnitDistinguishedNames() {
        return this.organizationalUnitDistinguishedNames;
    }

    public ServiceAccountCredentials serviceAccountCredentials() {
        return this.serviceAccountCredentials;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationalUnitDistinguishedNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAccountCredentials());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDirectoryConfigRequest)) {
            return false;
        }
        UpdateDirectoryConfigRequest other = (UpdateDirectoryConfigRequest)((Object)obj);
        return Objects.equals(this.directoryName(), other.directoryName()) && Objects.equals(this.organizationalUnitDistinguishedNames(), other.organizationalUnitDistinguishedNames()) && Objects.equals(this.serviceAccountCredentials(), other.serviceAccountCredentials());
    }

    public String toString() {
        return ToString.builder((String)"UpdateDirectoryConfigRequest").add("DirectoryName", (Object)this.directoryName()).add("OrganizationalUnitDistinguishedNames", this.organizationalUnitDistinguishedNames()).add("ServiceAccountCredentials", (Object)this.serviceAccountCredentials()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryName": {
                return Optional.of(clazz.cast(this.directoryName()));
            }
            case "OrganizationalUnitDistinguishedNames": {
                return Optional.of(clazz.cast(this.organizationalUnitDistinguishedNames()));
            }
            case "ServiceAccountCredentials": {
                return Optional.of(clazz.cast(this.serviceAccountCredentials()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AppStreamRequest.BuilderImpl
    implements Builder {
        private String directoryName;
        private List<String> organizationalUnitDistinguishedNames;
        private ServiceAccountCredentials serviceAccountCredentials;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDirectoryConfigRequest model) {
            super(model);
            this.directoryName(model.directoryName);
            this.organizationalUnitDistinguishedNames(model.organizationalUnitDistinguishedNames);
            this.serviceAccountCredentials(model.serviceAccountCredentials);
        }

        public final String getDirectoryName() {
            return this.directoryName;
        }

        @Override
        public final Builder directoryName(String directoryName) {
            this.directoryName = directoryName;
            return this;
        }

        public final void setDirectoryName(String directoryName) {
            this.directoryName = directoryName;
        }

        public final Collection<String> getOrganizationalUnitDistinguishedNames() {
            return this.organizationalUnitDistinguishedNames;
        }

        @Override
        public final Builder organizationalUnitDistinguishedNames(Collection<String> organizationalUnitDistinguishedNames) {
            this.organizationalUnitDistinguishedNames = OrganizationalUnitDistinguishedNamesListCopier.copy(organizationalUnitDistinguishedNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationalUnitDistinguishedNames(String ... organizationalUnitDistinguishedNames) {
            this.organizationalUnitDistinguishedNames(Arrays.asList(organizationalUnitDistinguishedNames));
            return this;
        }

        public final void setOrganizationalUnitDistinguishedNames(Collection<String> organizationalUnitDistinguishedNames) {
            this.organizationalUnitDistinguishedNames = OrganizationalUnitDistinguishedNamesListCopier.copy(organizationalUnitDistinguishedNames);
        }

        public final ServiceAccountCredentials.Builder getServiceAccountCredentials() {
            return this.serviceAccountCredentials != null ? this.serviceAccountCredentials.toBuilder() : null;
        }

        @Override
        public final Builder serviceAccountCredentials(ServiceAccountCredentials serviceAccountCredentials) {
            this.serviceAccountCredentials = serviceAccountCredentials;
            return this;
        }

        public final void setServiceAccountCredentials(ServiceAccountCredentials.BuilderImpl serviceAccountCredentials) {
            this.serviceAccountCredentials = serviceAccountCredentials != null ? serviceAccountCredentials.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateDirectoryConfigRequest build() {
            return new UpdateDirectoryConfigRequest(this);
        }
    }

    public static interface Builder
    extends AppStreamRequest.Builder,
    CopyableBuilder<Builder, UpdateDirectoryConfigRequest> {
        public Builder directoryName(String var1);

        public Builder organizationalUnitDistinguishedNames(Collection<String> var1);

        public Builder organizationalUnitDistinguishedNames(String ... var1);

        public Builder serviceAccountCredentials(ServiceAccountCredentials var1);

        default public Builder serviceAccountCredentials(Consumer<ServiceAccountCredentials.Builder> serviceAccountCredentials) {
            return this.serviceAccountCredentials((ServiceAccountCredentials)((ServiceAccountCredentials.Builder)ServiceAccountCredentials.builder().apply(serviceAccountCredentials)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

