/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.appstream.model.AppStreamRequest;
import software.amazon.awssdk.services.appstream.model.AuthenticationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeSessionsRequest
extends AppStreamRequest
implements ToCopyableBuilder<Builder, DescribeSessionsRequest> {
    private final String stackName;
    private final String fleetName;
    private final String userId;
    private final String nextToken;
    private final Integer limit;
    private final String authenticationType;

    private DescribeSessionsRequest(BuilderImpl builder) {
        super(builder);
        this.stackName = builder.stackName;
        this.fleetName = builder.fleetName;
        this.userId = builder.userId;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
        this.authenticationType = builder.authenticationType;
    }

    public String stackName() {
        return this.stackName;
    }

    public String fleetName() {
        return this.fleetName;
    }

    public String userId() {
        return this.userId;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer limit() {
        return this.limit;
    }

    public AuthenticationType authenticationType() {
        return AuthenticationType.fromValue(this.authenticationType);
    }

    public String authenticationTypeAsString() {
        return this.authenticationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSessionsRequest)) {
            return false;
        }
        DescribeSessionsRequest other = (DescribeSessionsRequest)((Object)obj);
        return Objects.equals(this.stackName(), other.stackName()) && Objects.equals(this.fleetName(), other.fleetName()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.authenticationTypeAsString(), other.authenticationTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"DescribeSessionsRequest").add("StackName", (Object)this.stackName()).add("FleetName", (Object)this.fleetName()).add("UserId", (Object)this.userId()).add("NextToken", (Object)this.nextToken()).add("Limit", (Object)this.limit()).add("AuthenticationType", (Object)this.authenticationTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackName": {
                return Optional.of(clazz.cast(this.stackName()));
            }
            case "FleetName": {
                return Optional.of(clazz.cast(this.fleetName()));
            }
            case "UserId": {
                return Optional.of(clazz.cast(this.userId()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "Limit": {
                return Optional.of(clazz.cast(this.limit()));
            }
            case "AuthenticationType": {
                return Optional.of(clazz.cast(this.authenticationTypeAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AppStreamRequest.BuilderImpl
    implements Builder {
        private String stackName;
        private String fleetName;
        private String userId;
        private String nextToken;
        private Integer limit;
        private String authenticationType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSessionsRequest model) {
            super(model);
            this.stackName(model.stackName);
            this.fleetName(model.fleetName);
            this.userId(model.userId);
            this.nextToken(model.nextToken);
            this.limit(model.limit);
            this.authenticationType(model.authenticationType);
        }

        public final String getStackName() {
            return this.stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getFleetName() {
            return this.fleetName;
        }

        @Override
        public final Builder fleetName(String fleetName) {
            this.fleetName = fleetName;
            return this;
        }

        public final void setFleetName(String fleetName) {
            this.fleetName = fleetName;
        }

        public final String getUserId() {
            return this.userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getAuthenticationType() {
            return this.authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType.toString());
            return this;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeSessionsRequest build() {
            return new DescribeSessionsRequest(this);
        }
    }

    public static interface Builder
    extends AppStreamRequest.Builder,
    CopyableBuilder<Builder, DescribeSessionsRequest> {
        public Builder stackName(String var1);

        public Builder fleetName(String var1);

        public Builder userId(String var1);

        public Builder nextToken(String var1);

        public Builder limit(Integer var1);

        public Builder authenticationType(String var1);

        public Builder authenticationType(AuthenticationType var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

