/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.appstream.model.AppStreamResponse;
import software.amazon.awssdk.services.appstream.model.DirectoryConfig;
import software.amazon.awssdk.services.appstream.model.DirectoryConfigListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDirectoryConfigsResponse
extends AppStreamResponse
implements ToCopyableBuilder<Builder, DescribeDirectoryConfigsResponse> {
    private final List<DirectoryConfig> directoryConfigs;
    private final String nextToken;

    private DescribeDirectoryConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.directoryConfigs = builder.directoryConfigs;
        this.nextToken = builder.nextToken;
    }

    public List<DirectoryConfig> directoryConfigs() {
        return this.directoryConfigs;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryConfigs());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDirectoryConfigsResponse)) {
            return false;
        }
        DescribeDirectoryConfigsResponse other = (DescribeDirectoryConfigsResponse)((Object)obj);
        return Objects.equals(this.directoryConfigs(), other.directoryConfigs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDirectoryConfigsResponse").add("DirectoryConfigs", this.directoryConfigs()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryConfigs": {
                return Optional.of(clazz.cast(this.directoryConfigs()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AppStreamResponse.BuilderImpl
    implements Builder {
        private List<DirectoryConfig> directoryConfigs;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDirectoryConfigsResponse model) {
            super(model);
            this.directoryConfigs(model.directoryConfigs);
            this.nextToken(model.nextToken);
        }

        public final Collection<DirectoryConfig.Builder> getDirectoryConfigs() {
            return this.directoryConfigs != null ? (Collection)this.directoryConfigs.stream().map(DirectoryConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder directoryConfigs(Collection<DirectoryConfig> directoryConfigs) {
            this.directoryConfigs = DirectoryConfigListCopier.copy(directoryConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directoryConfigs(DirectoryConfig ... directoryConfigs) {
            this.directoryConfigs(Arrays.asList(directoryConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directoryConfigs(Consumer<DirectoryConfig.Builder> ... directoryConfigs) {
            this.directoryConfigs(Stream.of(directoryConfigs).map(c -> (DirectoryConfig)((DirectoryConfig.Builder)DirectoryConfig.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDirectoryConfigs(Collection<DirectoryConfig.BuilderImpl> directoryConfigs) {
            this.directoryConfigs = DirectoryConfigListCopier.copyFromBuilder(directoryConfigs);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeDirectoryConfigsResponse build() {
            return new DescribeDirectoryConfigsResponse(this);
        }
    }

    public static interface Builder
    extends AppStreamResponse.Builder,
    CopyableBuilder<Builder, DescribeDirectoryConfigsResponse> {
        public Builder directoryConfigs(Collection<DirectoryConfig> var1);

        public Builder directoryConfigs(DirectoryConfig ... var1);

        public Builder directoryConfigs(Consumer<DirectoryConfig.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

