/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.transform.ComputeCapacityStatusMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ComputeCapacityStatus
implements StructuredPojo,
ToCopyableBuilder<Builder, ComputeCapacityStatus> {
    private final Integer desired;
    private final Integer running;
    private final Integer inUse;
    private final Integer available;

    private ComputeCapacityStatus(BuilderImpl builder) {
        this.desired = builder.desired;
        this.running = builder.running;
        this.inUse = builder.inUse;
        this.available = builder.available;
    }

    public Integer desired() {
        return this.desired;
    }

    public Integer running() {
        return this.running;
    }

    public Integer inUse() {
        return this.inUse;
    }

    public Integer available() {
        return this.available;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.desired());
        hashCode = 31 * hashCode + Objects.hashCode(this.running());
        hashCode = 31 * hashCode + Objects.hashCode(this.inUse());
        hashCode = 31 * hashCode + Objects.hashCode(this.available());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeCapacityStatus)) {
            return false;
        }
        ComputeCapacityStatus other = (ComputeCapacityStatus)obj;
        return Objects.equals(this.desired(), other.desired()) && Objects.equals(this.running(), other.running()) && Objects.equals(this.inUse(), other.inUse()) && Objects.equals(this.available(), other.available());
    }

    public String toString() {
        return ToString.builder((String)"ComputeCapacityStatus").add("Desired", (Object)this.desired()).add("Running", (Object)this.running()).add("InUse", (Object)this.inUse()).add("Available", (Object)this.available()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Desired": {
                return Optional.of(clazz.cast(this.desired()));
            }
            case "Running": {
                return Optional.of(clazz.cast(this.running()));
            }
            case "InUse": {
                return Optional.of(clazz.cast(this.inUse()));
            }
            case "Available": {
                return Optional.of(clazz.cast(this.available()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComputeCapacityStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer desired;
        private Integer running;
        private Integer inUse;
        private Integer available;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeCapacityStatus model) {
            this.desired(model.desired);
            this.running(model.running);
            this.inUse(model.inUse);
            this.available(model.available);
        }

        public final Integer getDesired() {
            return this.desired;
        }

        @Override
        public final Builder desired(Integer desired) {
            this.desired = desired;
            return this;
        }

        public final void setDesired(Integer desired) {
            this.desired = desired;
        }

        public final Integer getRunning() {
            return this.running;
        }

        @Override
        public final Builder running(Integer running) {
            this.running = running;
            return this;
        }

        public final void setRunning(Integer running) {
            this.running = running;
        }

        public final Integer getInUse() {
            return this.inUse;
        }

        @Override
        public final Builder inUse(Integer inUse) {
            this.inUse = inUse;
            return this;
        }

        public final void setInUse(Integer inUse) {
            this.inUse = inUse;
        }

        public final Integer getAvailable() {
            return this.available;
        }

        @Override
        public final Builder available(Integer available) {
            this.available = available;
            return this;
        }

        public final void setAvailable(Integer available) {
            this.available = available;
        }

        public ComputeCapacityStatus build() {
            return new ComputeCapacityStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ComputeCapacityStatus> {
        public Builder desired(Integer var1);

        public Builder running(Integer var1);

        public Builder inUse(Integer var1);

        public Builder available(Integer var1);
    }
}

