/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.appstream.model.StorageConnector;
import software.amazon.awssdk.services.appstream.model.StorageConnectorListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateStackRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateStackRequest> {
    private final String displayName;
    private final String description;
    private final String name;
    private final List<StorageConnector> storageConnectors;
    private final Boolean deleteStorageConnectors;

    private UpdateStackRequest(BuilderImpl builder) {
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.name = builder.name;
        this.storageConnectors = builder.storageConnectors;
        this.deleteStorageConnectors = builder.deleteStorageConnectors;
    }

    public String displayName() {
        return this.displayName;
    }

    public String description() {
        return this.description;
    }

    public String name() {
        return this.name;
    }

    public List<StorageConnector> storageConnectors() {
        return this.storageConnectors;
    }

    public Boolean deleteStorageConnectors() {
        return this.deleteStorageConnectors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.displayName() == null ? 0 : this.displayName().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.storageConnectors() == null ? 0 : this.storageConnectors().hashCode());
        hashCode = 31 * hashCode + (this.deleteStorageConnectors() == null ? 0 : this.deleteStorageConnectors().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStackRequest)) {
            return false;
        }
        UpdateStackRequest other = (UpdateStackRequest)((Object)obj);
        if (other.displayName() == null ^ this.displayName() == null) {
            return false;
        }
        if (other.displayName() != null && !other.displayName().equals(this.displayName())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.storageConnectors() == null ^ this.storageConnectors() == null) {
            return false;
        }
        if (other.storageConnectors() != null && !other.storageConnectors().equals(this.storageConnectors())) {
            return false;
        }
        if (other.deleteStorageConnectors() == null ^ this.deleteStorageConnectors() == null) {
            return false;
        }
        return other.deleteStorageConnectors() == null || other.deleteStorageConnectors().equals(this.deleteStorageConnectors());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.displayName() != null) {
            sb.append("DisplayName: ").append(this.displayName()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.storageConnectors() != null) {
            sb.append("StorageConnectors: ").append(this.storageConnectors()).append(",");
        }
        if (this.deleteStorageConnectors() != null) {
            sb.append("DeleteStorageConnectors: ").append(this.deleteStorageConnectors()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String displayName;
        private String description;
        private String name;
        private List<StorageConnector> storageConnectors;
        private Boolean deleteStorageConnectors;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStackRequest model) {
            this.setDisplayName(model.displayName);
            this.setDescription(model.description);
            this.setName(model.name);
            this.setStorageConnectors(model.storageConnectors);
            this.setDeleteStorageConnectors(model.deleteStorageConnectors);
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<StorageConnector> getStorageConnectors() {
            return this.storageConnectors;
        }

        @Override
        public final Builder storageConnectors(Collection<StorageConnector> storageConnectors) {
            this.storageConnectors = StorageConnectorListCopier.copy(storageConnectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConnectors(StorageConnector ... storageConnectors) {
            if (this.storageConnectors == null) {
                this.storageConnectors = new ArrayList<StorageConnector>(storageConnectors.length);
            }
            for (StorageConnector e : storageConnectors) {
                this.storageConnectors.add(e);
            }
            return this;
        }

        public final void setStorageConnectors(Collection<StorageConnector> storageConnectors) {
            this.storageConnectors = StorageConnectorListCopier.copy(storageConnectors);
        }

        @SafeVarargs
        public final void setStorageConnectors(StorageConnector ... storageConnectors) {
            if (this.storageConnectors == null) {
                this.storageConnectors = new ArrayList<StorageConnector>(storageConnectors.length);
            }
            for (StorageConnector e : storageConnectors) {
                this.storageConnectors.add(e);
            }
        }

        public final Boolean getDeleteStorageConnectors() {
            return this.deleteStorageConnectors;
        }

        @Override
        public final Builder deleteStorageConnectors(Boolean deleteStorageConnectors) {
            this.deleteStorageConnectors = deleteStorageConnectors;
            return this;
        }

        public final void setDeleteStorageConnectors(Boolean deleteStorageConnectors) {
            this.deleteStorageConnectors = deleteStorageConnectors;
        }

        public UpdateStackRequest build() {
            return new UpdateStackRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateStackRequest> {
        public Builder displayName(String var1);

        public Builder description(String var1);

        public Builder name(String var1);

        public Builder storageConnectors(Collection<StorageConnector> var1);

        public Builder storageConnectors(StorageConnector ... var1);

        public Builder deleteStorageConnectors(Boolean var1);
    }
}

