/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.model.MetadataCopier;
import software.amazon.awssdk.services.appstream.transform.ApplicationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Application
implements StructuredPojo,
ToCopyableBuilder<Builder, Application> {
    private final String name;
    private final String displayName;
    private final String iconURL;
    private final String launchPath;
    private final String launchParameters;
    private final Boolean enabled;
    private final Map<String, String> metadata;

    private Application(BuilderImpl builder) {
        this.name = builder.name;
        this.displayName = builder.displayName;
        this.iconURL = builder.iconURL;
        this.launchPath = builder.launchPath;
        this.launchParameters = builder.launchParameters;
        this.enabled = builder.enabled;
        this.metadata = builder.metadata;
    }

    public String name() {
        return this.name;
    }

    public String displayName() {
        return this.displayName;
    }

    public String iconURL() {
        return this.iconURL;
    }

    public String launchPath() {
        return this.launchPath;
    }

    public String launchParameters() {
        return this.launchParameters;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public Map<String, String> metadata() {
        return this.metadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.displayName() == null ? 0 : this.displayName().hashCode());
        hashCode = 31 * hashCode + (this.iconURL() == null ? 0 : this.iconURL().hashCode());
        hashCode = 31 * hashCode + (this.launchPath() == null ? 0 : this.launchPath().hashCode());
        hashCode = 31 * hashCode + (this.launchParameters() == null ? 0 : this.launchParameters().hashCode());
        hashCode = 31 * hashCode + (this.enabled() == null ? 0 : this.enabled().hashCode());
        hashCode = 31 * hashCode + (this.metadata() == null ? 0 : this.metadata().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Application)) {
            return false;
        }
        Application other = (Application)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.displayName() == null ^ this.displayName() == null) {
            return false;
        }
        if (other.displayName() != null && !other.displayName().equals(this.displayName())) {
            return false;
        }
        if (other.iconURL() == null ^ this.iconURL() == null) {
            return false;
        }
        if (other.iconURL() != null && !other.iconURL().equals(this.iconURL())) {
            return false;
        }
        if (other.launchPath() == null ^ this.launchPath() == null) {
            return false;
        }
        if (other.launchPath() != null && !other.launchPath().equals(this.launchPath())) {
            return false;
        }
        if (other.launchParameters() == null ^ this.launchParameters() == null) {
            return false;
        }
        if (other.launchParameters() != null && !other.launchParameters().equals(this.launchParameters())) {
            return false;
        }
        if (other.enabled() == null ^ this.enabled() == null) {
            return false;
        }
        if (other.enabled() != null && !other.enabled().equals(this.enabled())) {
            return false;
        }
        if (other.metadata() == null ^ this.metadata() == null) {
            return false;
        }
        return other.metadata() == null || other.metadata().equals(this.metadata());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.displayName() != null) {
            sb.append("DisplayName: ").append(this.displayName()).append(",");
        }
        if (this.iconURL() != null) {
            sb.append("IconURL: ").append(this.iconURL()).append(",");
        }
        if (this.launchPath() != null) {
            sb.append("LaunchPath: ").append(this.launchPath()).append(",");
        }
        if (this.launchParameters() != null) {
            sb.append("LaunchParameters: ").append(this.launchParameters()).append(",");
        }
        if (this.enabled() != null) {
            sb.append("Enabled: ").append(this.enabled()).append(",");
        }
        if (this.metadata() != null) {
            sb.append("Metadata: ").append(this.metadata()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ApplicationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private String displayName;
        private String iconURL;
        private String launchPath;
        private String launchParameters;
        private Boolean enabled;
        private Map<String, String> metadata;

        private BuilderImpl() {
        }

        private BuilderImpl(Application model) {
            this.setName(model.name);
            this.setDisplayName(model.displayName);
            this.setIconURL(model.iconURL);
            this.setLaunchPath(model.launchPath);
            this.setLaunchParameters(model.launchParameters);
            this.setEnabled(model.enabled);
            this.setMetadata(model.metadata);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getIconURL() {
            return this.iconURL;
        }

        @Override
        public final Builder iconURL(String iconURL) {
            this.iconURL = iconURL;
            return this;
        }

        public final void setIconURL(String iconURL) {
            this.iconURL = iconURL;
        }

        public final String getLaunchPath() {
            return this.launchPath;
        }

        @Override
        public final Builder launchPath(String launchPath) {
            this.launchPath = launchPath;
            return this;
        }

        public final void setLaunchPath(String launchPath) {
            this.launchPath = launchPath;
        }

        public final String getLaunchParameters() {
            return this.launchParameters;
        }

        @Override
        public final Builder launchParameters(String launchParameters) {
            this.launchParameters = launchParameters;
            return this;
        }

        public final void setLaunchParameters(String launchParameters) {
            this.launchParameters = launchParameters;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Map<String, String> getMetadata() {
            return this.metadata;
        }

        @Override
        public final Builder metadata(Map<String, String> metadata) {
            this.metadata = MetadataCopier.copy(metadata);
            return this;
        }

        public final void setMetadata(Map<String, String> metadata) {
            this.metadata = MetadataCopier.copy(metadata);
        }

        public Application build() {
            return new Application(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Application> {
        public Builder name(String var1);

        public Builder displayName(String var1);

        public Builder iconURL(String var1);

        public Builder launchPath(String var1);

        public Builder launchParameters(String var1);

        public Builder enabled(Boolean var1);

        public Builder metadata(Map<String, String> var1);
    }
}

