/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apprunner.model.EgressType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EgressConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EgressConfiguration> {
    private static final SdkField<String> EGRESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EgressType").getter(EgressConfiguration.getter(EgressConfiguration::egressTypeAsString)).setter(EgressConfiguration.setter(Builder::egressType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EgressType").build()}).build();
    private static final SdkField<String> VPC_CONNECTOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcConnectorArn").getter(EgressConfiguration.getter(EgressConfiguration::vpcConnectorArn)).setter(EgressConfiguration.setter(Builder::vpcConnectorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConnectorArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EGRESS_TYPE_FIELD, VPC_CONNECTOR_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("EgressType", EGRESS_TYPE_FIELD);
            this.put("VpcConnectorArn", VPC_CONNECTOR_ARN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String egressType;
    private final String vpcConnectorArn;

    private EgressConfiguration(BuilderImpl builder) {
        this.egressType = builder.egressType;
        this.vpcConnectorArn = builder.vpcConnectorArn;
    }

    public final EgressType egressType() {
        return EgressType.fromValue(this.egressType);
    }

    public final String egressTypeAsString() {
        return this.egressType;
    }

    public final String vpcConnectorArn() {
        return this.vpcConnectorArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.egressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConnectorArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EgressConfiguration)) {
            return false;
        }
        EgressConfiguration other = (EgressConfiguration)obj;
        return Objects.equals(this.egressTypeAsString(), other.egressTypeAsString()) && Objects.equals(this.vpcConnectorArn(), other.vpcConnectorArn());
    }

    public final String toString() {
        return ToString.builder((String)"EgressConfiguration").add("EgressType", (Object)this.egressTypeAsString()).add("VpcConnectorArn", (Object)this.vpcConnectorArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EgressType": {
                return Optional.ofNullable(clazz.cast(this.egressTypeAsString()));
            }
            case "VpcConnectorArn": {
                return Optional.ofNullable(clazz.cast(this.vpcConnectorArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EgressConfiguration, T> g) {
        return obj -> g.apply((EgressConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String egressType;
        private String vpcConnectorArn;

        private BuilderImpl() {
        }

        private BuilderImpl(EgressConfiguration model) {
            this.egressType(model.egressType);
            this.vpcConnectorArn(model.vpcConnectorArn);
        }

        public final String getEgressType() {
            return this.egressType;
        }

        public final void setEgressType(String egressType) {
            this.egressType = egressType;
        }

        @Override
        public final Builder egressType(String egressType) {
            this.egressType = egressType;
            return this;
        }

        @Override
        public final Builder egressType(EgressType egressType) {
            this.egressType(egressType == null ? null : egressType.toString());
            return this;
        }

        public final String getVpcConnectorArn() {
            return this.vpcConnectorArn;
        }

        public final void setVpcConnectorArn(String vpcConnectorArn) {
            this.vpcConnectorArn = vpcConnectorArn;
        }

        @Override
        public final Builder vpcConnectorArn(String vpcConnectorArn) {
            this.vpcConnectorArn = vpcConnectorArn;
            return this;
        }

        public EgressConfiguration build() {
            return new EgressConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EgressConfiguration> {
        public Builder egressType(String var1);

        public Builder egressType(EgressType var1);

        public Builder vpcConnectorArn(String var1);
    }
}

