/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.apprunner.model.AppRunnerRequest;
import software.amazon.awssdk.services.apprunner.model.IngressVpcConfiguration;
import software.amazon.awssdk.services.apprunner.model.Tag;
import software.amazon.awssdk.services.apprunner.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateVpcIngressConnectionRequest
extends AppRunnerRequest
implements ToCopyableBuilder<Builder, CreateVpcIngressConnectionRequest> {
    private static final SdkField<String> SERVICE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceArn").getter(CreateVpcIngressConnectionRequest.getter(CreateVpcIngressConnectionRequest::serviceArn)).setter(CreateVpcIngressConnectionRequest.setter(Builder::serviceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceArn").build()}).build();
    private static final SdkField<String> VPC_INGRESS_CONNECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcIngressConnectionName").getter(CreateVpcIngressConnectionRequest.getter(CreateVpcIngressConnectionRequest::vpcIngressConnectionName)).setter(CreateVpcIngressConnectionRequest.setter(Builder::vpcIngressConnectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcIngressConnectionName").build()}).build();
    private static final SdkField<IngressVpcConfiguration> INGRESS_VPC_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IngressVpcConfiguration").getter(CreateVpcIngressConnectionRequest.getter(CreateVpcIngressConnectionRequest::ingressVpcConfiguration)).setter(CreateVpcIngressConnectionRequest.setter(Builder::ingressVpcConfiguration)).constructor(IngressVpcConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngressVpcConfiguration").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateVpcIngressConnectionRequest.getter(CreateVpcIngressConnectionRequest::tags)).setter(CreateVpcIngressConnectionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ARN_FIELD, VPC_INGRESS_CONNECTION_NAME_FIELD, INGRESS_VPC_CONFIGURATION_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ServiceArn", SERVICE_ARN_FIELD);
            this.put("VpcIngressConnectionName", VPC_INGRESS_CONNECTION_NAME_FIELD);
            this.put("IngressVpcConfiguration", INGRESS_VPC_CONFIGURATION_FIELD);
            this.put("Tags", TAGS_FIELD);
        }
    });
    private final String serviceArn;
    private final String vpcIngressConnectionName;
    private final IngressVpcConfiguration ingressVpcConfiguration;
    private final List<Tag> tags;

    private CreateVpcIngressConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.serviceArn = builder.serviceArn;
        this.vpcIngressConnectionName = builder.vpcIngressConnectionName;
        this.ingressVpcConfiguration = builder.ingressVpcConfiguration;
        this.tags = builder.tags;
    }

    public final String serviceArn() {
        return this.serviceArn;
    }

    public final String vpcIngressConnectionName() {
        return this.vpcIngressConnectionName;
    }

    public final IngressVpcConfiguration ingressVpcConfiguration() {
        return this.ingressVpcConfiguration;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcIngressConnectionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingressVpcConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcIngressConnectionRequest)) {
            return false;
        }
        CreateVpcIngressConnectionRequest other = (CreateVpcIngressConnectionRequest)((Object)obj);
        return Objects.equals(this.serviceArn(), other.serviceArn()) && Objects.equals(this.vpcIngressConnectionName(), other.vpcIngressConnectionName()) && Objects.equals(this.ingressVpcConfiguration(), other.ingressVpcConfiguration()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateVpcIngressConnectionRequest").add("ServiceArn", (Object)this.serviceArn()).add("VpcIngressConnectionName", (Object)this.vpcIngressConnectionName()).add("IngressVpcConfiguration", (Object)this.ingressVpcConfiguration()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceArn": {
                return Optional.ofNullable(clazz.cast(this.serviceArn()));
            }
            case "VpcIngressConnectionName": {
                return Optional.ofNullable(clazz.cast(this.vpcIngressConnectionName()));
            }
            case "IngressVpcConfiguration": {
                return Optional.ofNullable(clazz.cast(this.ingressVpcConfiguration()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateVpcIngressConnectionRequest, T> g) {
        return obj -> g.apply((CreateVpcIngressConnectionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppRunnerRequest.BuilderImpl
    implements Builder {
        private String serviceArn;
        private String vpcIngressConnectionName;
        private IngressVpcConfiguration ingressVpcConfiguration;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcIngressConnectionRequest model) {
            super(model);
            this.serviceArn(model.serviceArn);
            this.vpcIngressConnectionName(model.vpcIngressConnectionName);
            this.ingressVpcConfiguration(model.ingressVpcConfiguration);
            this.tags(model.tags);
        }

        public final String getServiceArn() {
            return this.serviceArn;
        }

        public final void setServiceArn(String serviceArn) {
            this.serviceArn = serviceArn;
        }

        @Override
        public final Builder serviceArn(String serviceArn) {
            this.serviceArn = serviceArn;
            return this;
        }

        public final String getVpcIngressConnectionName() {
            return this.vpcIngressConnectionName;
        }

        public final void setVpcIngressConnectionName(String vpcIngressConnectionName) {
            this.vpcIngressConnectionName = vpcIngressConnectionName;
        }

        @Override
        public final Builder vpcIngressConnectionName(String vpcIngressConnectionName) {
            this.vpcIngressConnectionName = vpcIngressConnectionName;
            return this;
        }

        public final IngressVpcConfiguration.Builder getIngressVpcConfiguration() {
            return this.ingressVpcConfiguration != null ? this.ingressVpcConfiguration.toBuilder() : null;
        }

        public final void setIngressVpcConfiguration(IngressVpcConfiguration.BuilderImpl ingressVpcConfiguration) {
            this.ingressVpcConfiguration = ingressVpcConfiguration != null ? ingressVpcConfiguration.build() : null;
        }

        @Override
        public final Builder ingressVpcConfiguration(IngressVpcConfiguration ingressVpcConfiguration) {
            this.ingressVpcConfiguration = ingressVpcConfiguration;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVpcIngressConnectionRequest build() {
            return new CreateVpcIngressConnectionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AppRunnerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateVpcIngressConnectionRequest> {
        public Builder serviceArn(String var1);

        public Builder vpcIngressConnectionName(String var1);

        public Builder ingressVpcConfiguration(IngressVpcConfiguration var1);

        default public Builder ingressVpcConfiguration(Consumer<IngressVpcConfiguration.Builder> ingressVpcConfiguration) {
            return this.ingressVpcConfiguration((IngressVpcConfiguration)((IngressVpcConfiguration.Builder)IngressVpcConfiguration.builder().applyMutation(ingressVpcConfiguration)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

