/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.apprunner.AppRunnerClient;
import software.amazon.awssdk.services.apprunner.AppRunnerClientBuilder;
import software.amazon.awssdk.services.apprunner.AppRunnerServiceClientConfiguration;
import software.amazon.awssdk.services.apprunner.DefaultAppRunnerBaseClientBuilder;
import software.amazon.awssdk.services.apprunner.DefaultAppRunnerClient;
import software.amazon.awssdk.services.apprunner.endpoints.AppRunnerEndpointProvider;

@SdkInternalApi
final class DefaultAppRunnerClientBuilder
extends DefaultAppRunnerBaseClientBuilder<AppRunnerClientBuilder, AppRunnerClient>
implements AppRunnerClientBuilder {
    DefaultAppRunnerClientBuilder() {
    }

    @Override
    public DefaultAppRunnerClientBuilder endpointProvider(AppRunnerEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final AppRunnerClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultAppRunnerClientBuilder.validateClientOptions(clientConfiguration);
        AppRunnerServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultAppRunnerClient client = new DefaultAppRunnerClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private AppRunnerServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return AppRunnerServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

