/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apprunner.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeVpcIngressConnectionRequest extends AppRunnerRequest implements
        ToCopyableBuilder<DescribeVpcIngressConnectionRequest.Builder, DescribeVpcIngressConnectionRequest> {
    private static final SdkField<String> VPC_INGRESS_CONNECTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcIngressConnectionArn").getter(getter(DescribeVpcIngressConnectionRequest::vpcIngressConnectionArn))
            .setter(setter(Builder::vpcIngressConnectionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcIngressConnectionArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(VPC_INGRESS_CONNECTION_ARN_FIELD));

    private final String vpcIngressConnectionArn;

    private DescribeVpcIngressConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.vpcIngressConnectionArn = builder.vpcIngressConnectionArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the App Runner VPC Ingress Connection that you want a description for.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the App Runner VPC Ingress Connection that you want a description for.
     */
    public final String vpcIngressConnectionArn() {
        return vpcIngressConnectionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vpcIngressConnectionArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcIngressConnectionRequest)) {
            return false;
        }
        DescribeVpcIngressConnectionRequest other = (DescribeVpcIngressConnectionRequest) obj;
        return Objects.equals(vpcIngressConnectionArn(), other.vpcIngressConnectionArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeVpcIngressConnectionRequest").add("VpcIngressConnectionArn", vpcIngressConnectionArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcIngressConnectionArn":
            return Optional.ofNullable(clazz.cast(vpcIngressConnectionArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVpcIngressConnectionRequest, T> g) {
        return obj -> g.apply((DescribeVpcIngressConnectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppRunnerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeVpcIngressConnectionRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the App Runner VPC Ingress Connection that you want a description for.
         * </p>
         * 
         * @param vpcIngressConnectionArn
         *        The Amazon Resource Name (ARN) of the App Runner VPC Ingress Connection that you want a description
         *        for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcIngressConnectionArn(String vpcIngressConnectionArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppRunnerRequest.BuilderImpl implements Builder {
        private String vpcIngressConnectionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcIngressConnectionRequest model) {
            super(model);
            vpcIngressConnectionArn(model.vpcIngressConnectionArn);
        }

        public final String getVpcIngressConnectionArn() {
            return vpcIngressConnectionArn;
        }

        public final void setVpcIngressConnectionArn(String vpcIngressConnectionArn) {
            this.vpcIngressConnectionArn = vpcIngressConnectionArn;
        }

        @Override
        public final Builder vpcIngressConnectionArn(String vpcIngressConnectionArn) {
            this.vpcIngressConnectionArn = vpcIngressConnectionArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeVpcIngressConnectionRequest build() {
            return new DescribeVpcIngressConnectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
