/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apprunner.model.AppRunnerRequest;
import software.amazon.awssdk.services.apprunner.model.HealthCheckConfiguration;
import software.amazon.awssdk.services.apprunner.model.InstanceConfiguration;
import software.amazon.awssdk.services.apprunner.model.SourceConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateServiceRequest
extends AppRunnerRequest
implements ToCopyableBuilder<Builder, UpdateServiceRequest> {
    private static final SdkField<String> SERVICE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceArn").getter(UpdateServiceRequest.getter(UpdateServiceRequest::serviceArn)).setter(UpdateServiceRequest.setter(Builder::serviceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceArn").build()}).build();
    private static final SdkField<SourceConfiguration> SOURCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceConfiguration").getter(UpdateServiceRequest.getter(UpdateServiceRequest::sourceConfiguration)).setter(UpdateServiceRequest.setter(Builder::sourceConfiguration)).constructor(SourceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceConfiguration").build()}).build();
    private static final SdkField<InstanceConfiguration> INSTANCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceConfiguration").getter(UpdateServiceRequest.getter(UpdateServiceRequest::instanceConfiguration)).setter(UpdateServiceRequest.setter(Builder::instanceConfiguration)).constructor(InstanceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceConfiguration").build()}).build();
    private static final SdkField<String> AUTO_SCALING_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoScalingConfigurationArn").getter(UpdateServiceRequest.getter(UpdateServiceRequest::autoScalingConfigurationArn)).setter(UpdateServiceRequest.setter(Builder::autoScalingConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingConfigurationArn").build()}).build();
    private static final SdkField<HealthCheckConfiguration> HEALTH_CHECK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HealthCheckConfiguration").getter(UpdateServiceRequest.getter(UpdateServiceRequest::healthCheckConfiguration)).setter(UpdateServiceRequest.setter(Builder::healthCheckConfiguration)).constructor(HealthCheckConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ARN_FIELD, SOURCE_CONFIGURATION_FIELD, INSTANCE_CONFIGURATION_FIELD, AUTO_SCALING_CONFIGURATION_ARN_FIELD, HEALTH_CHECK_CONFIGURATION_FIELD));
    private final String serviceArn;
    private final SourceConfiguration sourceConfiguration;
    private final InstanceConfiguration instanceConfiguration;
    private final String autoScalingConfigurationArn;
    private final HealthCheckConfiguration healthCheckConfiguration;

    private UpdateServiceRequest(BuilderImpl builder) {
        super(builder);
        this.serviceArn = builder.serviceArn;
        this.sourceConfiguration = builder.sourceConfiguration;
        this.instanceConfiguration = builder.instanceConfiguration;
        this.autoScalingConfigurationArn = builder.autoScalingConfigurationArn;
        this.healthCheckConfiguration = builder.healthCheckConfiguration;
    }

    public final String serviceArn() {
        return this.serviceArn;
    }

    public final SourceConfiguration sourceConfiguration() {
        return this.sourceConfiguration;
    }

    public final InstanceConfiguration instanceConfiguration() {
        return this.instanceConfiguration;
    }

    public final String autoScalingConfigurationArn() {
        return this.autoScalingConfigurationArn;
    }

    public final HealthCheckConfiguration healthCheckConfiguration() {
        return this.healthCheckConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServiceRequest)) {
            return false;
        }
        UpdateServiceRequest other = (UpdateServiceRequest)((Object)obj);
        return Objects.equals(this.serviceArn(), other.serviceArn()) && Objects.equals(this.sourceConfiguration(), other.sourceConfiguration()) && Objects.equals(this.instanceConfiguration(), other.instanceConfiguration()) && Objects.equals(this.autoScalingConfigurationArn(), other.autoScalingConfigurationArn()) && Objects.equals(this.healthCheckConfiguration(), other.healthCheckConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateServiceRequest").add("ServiceArn", (Object)this.serviceArn()).add("SourceConfiguration", (Object)this.sourceConfiguration()).add("InstanceConfiguration", (Object)this.instanceConfiguration()).add("AutoScalingConfigurationArn", (Object)this.autoScalingConfigurationArn()).add("HealthCheckConfiguration", (Object)this.healthCheckConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceArn": {
                return Optional.ofNullable(clazz.cast(this.serviceArn()));
            }
            case "SourceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sourceConfiguration()));
            }
            case "InstanceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.instanceConfiguration()));
            }
            case "AutoScalingConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.autoScalingConfigurationArn()));
            }
            case "HealthCheckConfiguration": {
                return Optional.ofNullable(clazz.cast(this.healthCheckConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateServiceRequest, T> g) {
        return obj -> g.apply((UpdateServiceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppRunnerRequest.BuilderImpl
    implements Builder {
        private String serviceArn;
        private SourceConfiguration sourceConfiguration;
        private InstanceConfiguration instanceConfiguration;
        private String autoScalingConfigurationArn;
        private HealthCheckConfiguration healthCheckConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServiceRequest model) {
            super(model);
            this.serviceArn(model.serviceArn);
            this.sourceConfiguration(model.sourceConfiguration);
            this.instanceConfiguration(model.instanceConfiguration);
            this.autoScalingConfigurationArn(model.autoScalingConfigurationArn);
            this.healthCheckConfiguration(model.healthCheckConfiguration);
        }

        public final String getServiceArn() {
            return this.serviceArn;
        }

        public final void setServiceArn(String serviceArn) {
            this.serviceArn = serviceArn;
        }

        @Override
        @Transient
        public final Builder serviceArn(String serviceArn) {
            this.serviceArn = serviceArn;
            return this;
        }

        public final SourceConfiguration.Builder getSourceConfiguration() {
            return this.sourceConfiguration != null ? this.sourceConfiguration.toBuilder() : null;
        }

        public final void setSourceConfiguration(SourceConfiguration.BuilderImpl sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration != null ? sourceConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder sourceConfiguration(SourceConfiguration sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration;
            return this;
        }

        public final InstanceConfiguration.Builder getInstanceConfiguration() {
            return this.instanceConfiguration != null ? this.instanceConfiguration.toBuilder() : null;
        }

        public final void setInstanceConfiguration(InstanceConfiguration.BuilderImpl instanceConfiguration) {
            this.instanceConfiguration = instanceConfiguration != null ? instanceConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder instanceConfiguration(InstanceConfiguration instanceConfiguration) {
            this.instanceConfiguration = instanceConfiguration;
            return this;
        }

        public final String getAutoScalingConfigurationArn() {
            return this.autoScalingConfigurationArn;
        }

        public final void setAutoScalingConfigurationArn(String autoScalingConfigurationArn) {
            this.autoScalingConfigurationArn = autoScalingConfigurationArn;
        }

        @Override
        @Transient
        public final Builder autoScalingConfigurationArn(String autoScalingConfigurationArn) {
            this.autoScalingConfigurationArn = autoScalingConfigurationArn;
            return this;
        }

        public final HealthCheckConfiguration.Builder getHealthCheckConfiguration() {
            return this.healthCheckConfiguration != null ? this.healthCheckConfiguration.toBuilder() : null;
        }

        public final void setHealthCheckConfiguration(HealthCheckConfiguration.BuilderImpl healthCheckConfiguration) {
            this.healthCheckConfiguration = healthCheckConfiguration != null ? healthCheckConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder healthCheckConfiguration(HealthCheckConfiguration healthCheckConfiguration) {
            this.healthCheckConfiguration = healthCheckConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateServiceRequest build() {
            return new UpdateServiceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppRunnerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateServiceRequest> {
        public Builder serviceArn(String var1);

        public Builder sourceConfiguration(SourceConfiguration var1);

        default public Builder sourceConfiguration(Consumer<SourceConfiguration.Builder> sourceConfiguration) {
            return this.sourceConfiguration((SourceConfiguration)((SourceConfiguration.Builder)SourceConfiguration.builder().applyMutation(sourceConfiguration)).build());
        }

        public Builder instanceConfiguration(InstanceConfiguration var1);

        default public Builder instanceConfiguration(Consumer<InstanceConfiguration.Builder> instanceConfiguration) {
            return this.instanceConfiguration((InstanceConfiguration)((InstanceConfiguration.Builder)InstanceConfiguration.builder().applyMutation(instanceConfiguration)).build());
        }

        public Builder autoScalingConfigurationArn(String var1);

        public Builder healthCheckConfiguration(HealthCheckConfiguration var1);

        default public Builder healthCheckConfiguration(Consumer<HealthCheckConfiguration.Builder> healthCheckConfiguration) {
            return this.healthCheckConfiguration((HealthCheckConfiguration)((HealthCheckConfiguration.Builder)HealthCheckConfiguration.builder().applyMutation(healthCheckConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

